/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.circuits.ICircuitSocketType;
import forestry.core.circuits.EnumCircuitBoardType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CircuitBoard
implements ICircuitBoard {
    private final EnumCircuitBoardType type;
    @Nullable
    private final ICircuitLayout layout;
    private final ICircuit[] circuits;

    public CircuitBoard(EnumCircuitBoardType type, @Nullable ICircuitLayout layout, ICircuit[] circuits) {
        this.type = type;
        this.layout = layout;
        this.circuits = circuits;
    }

    public CircuitBoard(CompoundNBT compound) {
        this.type = EnumCircuitBoardType.values()[compound.func_74765_d("T")];
        ICircuitLayout layout = null;
        if (compound.func_74764_b("LY")) {
            layout = ChipsetManager.circuitRegistry.getLayout(compound.func_74779_i("LY"));
        }
        if (layout == null) {
            ChipsetManager.circuitRegistry.getDefaultLayout();
        }
        this.layout = layout;
        this.circuits = new ICircuit[4];
        for (int i = 0; i < 4; ++i) {
            ICircuit circuit;
            if (!compound.func_74764_b("CA.I" + i) || (circuit = ChipsetManager.circuitRegistry.getCircuit(compound.func_74779_i("CA.I" + i))) == null) continue;
            this.circuits[i] = circuit;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getPrimaryColor() {
        return this.type.getPrimaryColor();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getSecondaryColor() {
        return this.type.getSecondaryColor();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addTooltip(List<ITextComponent> list) {
        if (this.layout != null) {
            list.add((ITextComponent)new StringTextComponent(this.layout.getUsage() + ":").func_240699_a_(TextFormatting.GOLD));
            ArrayList<ITextComponent> extendedTooltip = new ArrayList<ITextComponent>();
            for (ICircuit circuit : this.circuits) {
                if (circuit == null) continue;
                circuit.addTooltip(extendedTooltip);
            }
            if (Screen.func_231173_s_() || extendedTooltip.size() <= 4) {
                list.addAll(extendedTooltip);
            } else {
                list.add((ITextComponent)new StringTextComponent("<").func_240701_a_(new TextFormatting[]{TextFormatting.UNDERLINE, TextFormatting.GRAY}).func_230529_a_((ITextComponent)new TranslationTextComponent("for.gui.tooltip.tmi")).func_230529_a_((ITextComponent)new StringTextComponent(">")));
            }
        } else {
            int socketCount = this.type.getSockets();
            String localizationKey = "item.forestry.circuit_board.tooltip." + (socketCount == 1 ? "singular" : "plural");
            list.add((ITextComponent)new TranslationTextComponent(localizationKey, new Object[]{this.type.getSockets()}).func_240699_a_(TextFormatting.GRAY));
        }
    }

    @Override
    public CompoundNBT write(CompoundNBT compound) {
        compound.func_74777_a("T", (short)this.type.ordinal());
        if (this.layout != null) {
            compound.func_74778_a("LY", this.layout.getUID());
        }
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            compound.func_74778_a("CA.I" + i, circuit.getUID());
        }
        return compound;
    }

    @Override
    public void onInsertion(Object tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            circuit.onInsertion(i, tile);
        }
    }

    @Override
    public void onLoad(Object tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            circuit.onLoad(i, tile);
        }
    }

    @Override
    public void onRemoval(Object tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            circuit.onRemoval(i, tile);
        }
    }

    @Override
    public void onTick(Object tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            circuit.onTick(i, tile);
        }
    }

    @Override
    public ICircuit[] getCircuits() {
        return this.circuits;
    }

    @Override
    public ICircuitSocketType getSocketType() {
        if (this.layout == null) {
            return CircuitSocketType.NONE;
        }
        return this.layout.getSocketType();
    }
}

