/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.climate.ClimateCapabilities;
import forestry.api.climate.IClimateListener;
import forestry.api.climate.IClimateProvider;
import forestry.api.climate.IClimateRoot;
import forestry.api.climate.IClimateState;
import forestry.api.climate.IWorldClimateHolder;
import forestry.core.DefaultClimateProvider;
import forestry.core.climate.ClimateStateHelper;
import forestry.core.climate.WorldClimateHolder;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraftforge.common.util.LazyOptional;

public class ClimateRoot
implements IClimateRoot {
    private static final ClimateRoot INSTANCE = new ClimateRoot();

    public static ClimateRoot getInstance() {
        return INSTANCE;
    }

    @Override
    public LazyOptional<IClimateListener> getListener(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && ClimateCapabilities.CLIMATE_LISTENER != null) {
            return tileEntity.getCapability(ClimateCapabilities.CLIMATE_LISTENER, null);
        }
        return LazyOptional.empty();
    }

    @Override
    public IClimateProvider getDefaultClimate(World world, BlockPos pos) {
        return new DefaultClimateProvider(world, pos);
    }

    @Override
    public IClimateState getState(World world, BlockPos pos) {
        IWorldClimateHolder climateHolder = this.getWorldClimate(world);
        return climateHolder.getState(pos);
    }

    @Override
    public IClimateState getBiomeState(World worldObj, BlockPos coordinates) {
        Biome biome = worldObj.func_226691_t_(coordinates);
        return ClimateStateHelper.of(biome.func_225486_c(coordinates), biome.func_76727_i());
    }

    @Override
    public IWorldClimateHolder getWorldClimate(World world) {
        DimensionSavedDataManager storage = ((ServerWorld)world).func_217481_x();
        WorldClimateHolder holder = (WorldClimateHolder)storage.func_215752_a(() -> new WorldClimateHolder("forestry_climate"), "forestry_climate");
        holder.setWorld(world);
        return holder;
    }
}

