/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import forestry.core.data.ForestryBlockLootTables;
import forestry.core.data.ForestryChestLootTables;
import forestry.core.utils.Log;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForestryLootTableProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator dataGenerator;
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> tables = ImmutableList.of((Object)Pair.of(ForestryBlockLootTables::new, (Object)LootParameterSets.field_216267_h), (Object)Pair.of(ForestryChestLootTables::new, (Object)LootParameterSets.field_216261_b));

    public ForestryLootTableProvider(DataGenerator dataGeneratorIn) {
        this.dataGenerator = dataGeneratorIn;
    }

    public void func_200398_a(DirectoryCache cache) {
        Path path = this.dataGenerator.func_200391_b();
        HashMap map = Maps.newHashMap();
        this.tables.forEach(entry -> ((Consumer)((Supplier)entry.getFirst()).get()).accept((location, builder) -> {
            if (map.put(location, builder.func_216039_a((LootParameterSet)entry.getSecond()).func_216038_b()) != null) {
                throw new IllegalStateException("Duplicate loot table " + location);
            }
        }));
        ValidationTracker validationtracker = new ValidationTracker(LootParameterSets.field_216266_g, location -> null, map::get);
        this.validate(map, validationtracker);
        Multimap multimap = validationtracker.func_227527_a_();
        if (!multimap.isEmpty()) {
            multimap.forEach((location, message) -> Log.warning("Found validation problem in " + location + ": " + message, new Object[0]));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        map.forEach((location, table) -> {
            Path path1 = ForestryLootTableProvider.getPath(path, location);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)table), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save loot table {}", (Object)path1, (Object)ioexception);
            }
        });
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker tracker) {
        map.forEach((location, loot) -> LootTableManager.func_227508_a_((ValidationTracker)tracker, (ResourceLocation)location, (LootTable)loot));
    }

    private static Path getPath(Path path, ResourceLocation id) {
        return path.resolve("data/" + id.func_110624_b() + "/loot_tables/" + id.func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "Forestry LootTables";
    }
}

