/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import forestry.api.apiculture.genetics.EnumBeeType;
import forestry.api.arboriculture.genetics.EnumGermlingType;
import forestry.apiculture.features.ApicultureBlocks;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.arboriculture.features.ArboricultureItems;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.core.data.ForestryTags;
import forestry.core.features.CoreItems;
import forestry.core.loot.OrganismFunction;
import forestry.storage.features.BackpackItems;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.EmptyLootEntry;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.TagLootEntry;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class LootTableHelper {
    @Nullable
    public static LootTableHelper instance;
    protected final Multimap<ResourceLocation, Entry> entries = LinkedHashMultimap.create();

    public static LootTableHelper getInstance() {
        if (instance == null) {
            instance = new LootTableHelper();
        }
        return instance;
    }

    public LootTableHelper() {
        this.add(LootTables.field_186424_f, "apiculture", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("forestry_apiculture_bees").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(this.beeLoot(BeeDefinition.STEADFAST)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(9))));
        this.add(LootTables.field_186424_f, "factory", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("forestry_factory_items").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a(CoreItems.BROKEN_BRONZE_PICKAXE.item()).func_216086_a(30)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a(CoreItems.BROKEN_BRONZE_SHOVEL.item()).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a(CoreItems.KIT_PICKAXE.item()).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a(CoreItems.KIT_SHOVEL.item()).func_216086_a(5)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(50))));
        this.add(LootTables.field_186424_f, "storage", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("forestry_storage_items").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a(BackpackItems.MINER_BACKPACK.item())).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(20))));
        this.add(LootTables.field_186429_k, "apiculture", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("forestry_apiculture_bees").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(this.beeLoot(BeeDefinition.STEADFAST)).func_216045_a((LootEntry.Builder)this.beeLoot(BeeDefinition.STEADFAST).func_216086_a(3).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(6))));
        this.add(LootTables.field_186429_k, "arboriculture", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("forestry_arboriculture_items").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(this.saplingLoot(TreeDefinition.Acacia)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(3))));
        this.add(LootTables.field_186429_k, "factory", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("forestry_factory_items").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a(CoreItems.ASH.item()).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)7.0f, (float)12.0f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(1))));
        this.add(LootTables.field_186421_c, "apiculture", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("forestry_apiculture_bees").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_216045_a((LootEntry.Builder)this.beeLoot(BeeDefinition.STEADFAST).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))).func_216086_a(20)).func_216045_a((LootEntry.Builder)this.beeLoot(BeeDefinition.ENDED).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_216086_a(20)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(60))));
        this.add(LootTables.field_186421_c, "arboriculture", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("forestry_arboriculture_items").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a(ArboricultureItems.GRAFTER.item())).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(1))));
        this.add(LootTables.field_186431_m, "apiculture", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("forestry_apiculture_bees").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(this.beeLoot(BeeDefinition.STEADFAST)).func_216045_a((LootEntry.Builder)this.beeLoot(BeeDefinition.WINTRY).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_216086_a(2)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(7))));
        this.add(LootTables.field_186430_l, "apiculture", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("forestry_apiculture_bees").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(this.beeLoot(BeeDefinition.STEADFAST)).func_216045_a((LootEntry.Builder)this.beeLoot(BeeDefinition.TROPICAL).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_216086_a(3)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(6))));
        this.add(LootTables.field_186430_l, "arboriculture", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("forestry_arboriculture_items").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(this.saplingLoot(TreeDefinition.Sipiri)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(9))));
        this.add(LootTables.field_186425_g, "apiculture", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("forestry_apiculture_bees").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(this.beeLoot(BeeDefinition.STEADFAST)).func_216045_a(this.beeLoot(BeeDefinition.SINISTER)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(8))));
        this.add(LootTables.field_186422_d, "apiculture", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("forestry_apiculture_bees").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(this.beeLoot(BeeDefinition.STEADFAST)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(9))));
        this.add(LootTables.field_186420_b, "apiculture", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("forestry_apiculture_bees").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a(ApicultureItems.SCOOP.item()))));
        this.add(LootTables.field_186428_j, "apiculture", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("forestry_apiculture_bees").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(this.beeLoot(BeeDefinition.STEADFAST)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(9))));
        this.add(LootTables.field_186427_i, "apiculture", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("forestry_apiculture_bees").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(this.beeLoot(BeeDefinition.STEADFAST)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(9))));
        this.add(LootTables.field_186426_h, "apiculture", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("forestry_apiculture_bees").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(this.beeLoot(BeeDefinition.STEADFAST)).func_216045_a((LootEntry.Builder)this.beeLoot(BeeDefinition.MONASTIC).func_216086_a(6)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(3))));
        this.add(new ResourceLocation("forestry", "chests/village_naturalist"), "arboriculture", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("forestry_arboriculture_items").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)3)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a(ArboricultureItems.GRAFTER.item())).func_216045_a((LootEntry.Builder)this.saplingLoot(TreeDefinition.Lime).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)this.saplingLoot(TreeDefinition.Cherry).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)this.saplingLoot(TreeDefinition.Larch).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a(this.saplingLoot(TreeDefinition.Teak)).func_216045_a(this.saplingLoot(TreeDefinition.Padauk))));
        this.add(new ResourceLocation("forestry", "chests/village_naturalist"), "apiculture", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("forestry_apiculture_items").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)4)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a(ApicultureBlocks.CANDLE.block()).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)7.0f, (float)12.0f))).func_216086_a(10)).func_216045_a((LootEntry.Builder)TagLootEntry.func_216176_b(ForestryTags.Items.BEE_COMBS).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a(ApicultureItems.SCOOP.item()).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a(ApicultureItems.SMOKER))).func_216040_a(LootPool.func_216096_a().name("forestry_apiculture_bees").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)3)).func_216045_a((LootEntry.Builder)this.beeLoot(BeeDefinition.COMMON).func_216086_a(6)).func_216045_a((LootEntry.Builder)this.beeLoot(BeeDefinition.MEADOWS).func_216086_a(6)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(3))));
    }

    private StandaloneLootEntry.Builder<?> saplingLoot(TreeDefinition definition) {
        return this.saplingLoot(EnumGermlingType.SAPLING, definition);
    }

    private StandaloneLootEntry.Builder<?> saplingLoot(EnumGermlingType type, TreeDefinition definition) {
        return ItemLootEntry.func_216168_a((IItemProvider)this.saplingItem(type)).func_212841_b_(OrganismFunction.fromDefinition(definition));
    }

    private StandaloneLootEntry.Builder<?> beeLoot(BeeDefinition definition) {
        return this.beeLoot(EnumBeeType.DRONE, definition);
    }

    private StandaloneLootEntry.Builder<?> beeLoot(EnumBeeType type, BeeDefinition definition) {
        return ItemLootEntry.func_216168_a((IItemProvider)this.beeItem(type)).func_212841_b_(OrganismFunction.fromDefinition(definition));
    }

    private Item saplingItem(EnumGermlingType type) {
        switch (type) {
            case POLLEN: {
                return ArboricultureItems.POLLEN_FERTILE.item();
            }
        }
        return ArboricultureItems.SAPLING.item();
    }

    private Item beeItem(EnumBeeType type) {
        switch (type) {
            case QUEEN: {
                return ApicultureItems.BEE_QUEEN.item();
            }
            case LARVAE: {
                return ApicultureItems.BEE_LARVAE.item();
            }
            case PRINCESS: {
                return ApicultureItems.BEE_PRINCESS.item();
            }
        }
        return ApicultureItems.BEE_DRONE.item();
    }

    protected void add(ResourceLocation location, String extension, LootTable.Builder builder) {
        this.entries.put((Object)location, (Object)new Entry(location, extension, builder));
    }

    public static class Entry {
        public final ResourceLocation defaultLocation;
        public final String extension;
        public final LootTable.Builder builder;

        public Entry(ResourceLocation defaultLocation, String extension, LootTable.Builder builder) {
            this.defaultLocation = defaultLocation;
            this.extension = extension;
            this.builder = builder;
        }

        public ResourceLocation getLocation() {
            return new ResourceLocation("forestry", this.defaultLocation.func_110623_a() + "/" + this.extension);
        }
    }
}

