/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.modules.features.FeatureItem;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3i;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ModelProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final String folder;
    protected final Map<String, ModelBuilder> pathToBuilder = Maps.newLinkedHashMap();
    protected final DataGenerator generator;

    public ModelProvider(DataGenerator generator, String folder) {
        this.generator = generator;
        this.folder = folder;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.pathToBuilder.clear();
        this.registerModels();
        this.pathToBuilder.forEach((key, builder) -> {
            JsonObject jsonobject = builder.serialize();
            Path path = this.makePath((String)key);
            try {
                String s = GSON.toJson((JsonElement)jsonobject);
                String s1 = field_208307_a.hashUnencodedChars((CharSequence)s).toString();
                if (!Objects.equals(cache.func_208323_a(path), s1) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedwriter.write(s);
                    }
                }
                cache.func_208316_a(path, s1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save models to {}", (Object)path, (Object)ioexception);
            }
        });
    }

    protected abstract void registerModels();

    protected void registerModel(Item item, ModelBuilder builder) {
        this.registerModel(item.getRegistryName().func_110623_a(), builder);
    }

    protected void registerModel(Block block, ModelBuilder builder) {
        this.registerModel(block.getRegistryName().func_110623_a(), builder);
    }

    protected void registerModel(FeatureItem feature, ModelBuilder builder) {
        this.registerModel((Item)feature.item(), builder);
    }

    protected void registerModel(String path, ModelBuilder builder) {
        this.pathToBuilder.put(path, builder);
    }

    protected Path makePath(String location) {
        return this.generator.func_200391_b().resolve("assets/forestry/models/" + this.folder + "/" + location + ".json");
    }

    public String func_200397_b() {
        return "Model Provider";
    }

    private static JsonElement serializeVex(Vector3i vector) {
        JsonArray array = new JsonArray();
        array.add((Number)vector.func_177958_n());
        array.add((Number)vector.func_177956_o());
        array.add((Number)vector.func_177952_p());
        return array;
    }

    public static class Face {
        private final String texture;
        @Nullable
        private Direction cullFace;
        private int tintIndex = -1;
        private BlockFaceUV uv;

        public Face(String texture, float[] uvs) {
            this.texture = texture;
            this.uv = new BlockFaceUV(uvs, 0);
        }

        public Face cullFace(Direction cullFace) {
            this.cullFace = cullFace;
            return this;
        }

        public Face tint(int tintIndex) {
            this.tintIndex = tintIndex;
            return this;
        }

        public Face rotation(int rotation) {
            this.uv = new BlockFaceUV(this.uv.field_178351_a, rotation);
            return this;
        }

        private JsonElement serialize() {
            float[] uvs;
            JsonObject obj = new JsonObject();
            JsonArray uvObject = new JsonArray();
            for (float v : uvs = this.uv.field_178351_a) {
                uvObject.add((Number)Float.valueOf(v));
            }
            obj.add("uv", (JsonElement)uvObject);
            if (this.cullFace != null) {
                obj.addProperty("cullface", this.cullFace.func_176610_l());
            }
            obj.addProperty("rotation", (Number)this.uv.field_178350_b);
            if (this.tintIndex > 0) {
                obj.addProperty("tintindex", (Number)this.tintIndex);
            }
            obj.addProperty("texture", this.texture);
            return obj;
        }
    }

    public static class Rotation {
        private Vector3i origin = Vector3i.field_177959_e;
        @Nullable
        private Direction.Axis axis;
        @Nullable
        private Float angle;
        @Nullable
        private Boolean rescale = null;

        public Rotation origin(Vector3i origin) {
            this.origin = origin;
            return this;
        }

        public Rotation axis(Direction.Axis axis) {
            this.axis = axis;
            return this;
        }

        public Rotation angle(float angle) {
            this.angle = Float.valueOf(angle);
            return this;
        }

        public Rotation rescale(boolean rescale) {
            this.rescale = rescale;
            return this;
        }

        private JsonElement serialize() {
            JsonObject obj = new JsonObject();
            if (this.axis != null) {
                obj.addProperty("axis", this.axis.func_176610_l());
            }
            if (this.origin == Vector3i.field_177959_e) {
                obj.add("origin", ModelProvider.serializeVex(this.origin));
            }
            if (this.angle != null) {
                obj.addProperty("angle", (Number)this.angle);
            }
            if (this.rescale != null) {
                obj.addProperty("rescale", this.rescale);
            }
            return obj;
        }
    }

    public static class Element {
        private final Vector3i from;
        private final Vector3i to;
        private final Face[] faces = new Face[6];
        private boolean shade = true;
        @Nullable
        public Rotation rotation;

        public Element(Vector3i from, Vector3i to) {
            this.from = from;
            this.to = to;
        }

        public Element shade(boolean shade) {
            this.shade = shade;
            return this;
        }

        public Element face(Direction direction, Face face) {
            this.faces[direction.func_176745_a()] = face;
            return this;
        }

        public Element rotation(Rotation rotation) {
            this.rotation = rotation;
            return this;
        }

        private JsonElement serialize() {
            JsonObject obj = new JsonObject();
            obj.add("from", ModelProvider.serializeVex(this.from));
            obj.add("to", ModelProvider.serializeVex(this.to));
            obj.addProperty("shade", Boolean.valueOf(this.shade));
            if (this.rotation != null) {
                obj.add("rotation", this.rotation.serialize());
            }
            JsonObject facesObj = new JsonObject();
            for (int i = 0; i < this.faces.length; ++i) {
                Face face = this.faces[i];
                if (face == null) continue;
                Direction direction = Direction.func_82600_a((int)i);
                facesObj.add(direction.func_176610_l(), face.serialize());
            }
            obj.add("faces", (JsonElement)facesObj);
            return obj;
        }
    }

    public static class ModelBuilder {
        @Nullable
        public ResourceLocation parent;
        @Nullable
        public ResourceLocation loader;
        public final Map<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();
        public final Map<String, JsonElement> loaderData = new HashMap<String, JsonElement>();
        public final List<Element> elements = new LinkedList<Element>();
        @Nullable
        private Boolean ambientOcclusion = null;

        public ModelBuilder element(Element element) {
            this.elements.add(element);
            return this;
        }

        public ModelBuilder ambientOcclusion(boolean ambientOcclusion) {
            this.ambientOcclusion = ambientOcclusion;
            return this;
        }

        public ModelBuilder loader(ResourceLocation loader) {
            this.loader = loader;
            return this;
        }

        public ModelBuilder loaderData(String key, JsonElement element) {
            this.loaderData.put(key, element);
            return this;
        }

        public ModelBuilder parent(String parent) {
            return this.parent(new ResourceLocation(parent));
        }

        public ModelBuilder parent(ResourceLocation parent) {
            this.parent = parent;
            return this;
        }

        public ModelBuilder particle(ResourceLocation location) {
            return this.texture("particle", location);
        }

        public ModelBuilder item() {
            return this.parent("item/generated");
        }

        public ModelBuilder layer(int index, ResourceLocation location) {
            this.textures.put("layer" + index, location);
            return this;
        }

        public ModelBuilder texture(String key, ResourceLocation location) {
            this.textures.put(key, location);
            return this;
        }

        public JsonObject serialize() {
            JsonObject object = new JsonObject();
            if (this.parent != null) {
                object.addProperty("parent", this.parent.toString());
            }
            if (this.loader != null) {
                object.addProperty("loader", this.loader.toString());
            }
            if (!this.loaderData.isEmpty()) {
                for (Map.Entry<String, JsonElement> entry : this.loaderData.entrySet()) {
                    object.add(entry.getKey(), entry.getValue());
                }
            }
            JsonObject texturesObj = new JsonObject();
            if (!this.textures.isEmpty()) {
                for (Map.Entry<String, ResourceLocation> entry : this.textures.entrySet()) {
                    texturesObj.addProperty(entry.getKey(), entry.getValue().toString());
                }
                object.add("textures", (JsonElement)texturesObj);
            }
            if (this.ambientOcclusion != null) {
                object.addProperty("ambientocclusion", this.ambientOcclusion);
            }
            if (!this.elements.isEmpty()) {
                JsonArray jsonArray = new JsonArray();
                for (Element element : this.elements) {
                    jsonArray.add(element.serialize());
                }
                object.add("elements", (JsonElement)jsonArray);
            }
            return object;
        }
    }
}

