/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.api.recipes.IFabricatorSmeltingRecipe;
import forestry.factory.recipes.RecipeSerializers;
import java.util.function.Consumer;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FabricatorSmeltingRecipeBuilder {
    private int meltingPoint;
    private Ingredient resource;
    private FluidStack product;

    public FabricatorSmeltingRecipeBuilder setMeltingPoint(int meltingPoint) {
        this.meltingPoint = meltingPoint;
        return this;
    }

    public FabricatorSmeltingRecipeBuilder setResource(Ingredient resource) {
        this.resource = resource;
        return this;
    }

    public FabricatorSmeltingRecipeBuilder setProduct(FluidStack product) {
        this.product = product;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.meltingPoint, this.resource, this.product));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final int meltingPoint;
        private final Ingredient resource;
        private final FluidStack product;

        public Result(ResourceLocation id, int meltingPoint, Ingredient resource, FluidStack product) {
            this.id = id;
            this.meltingPoint = meltingPoint;
            this.resource = resource;
            this.product = product;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("melting", (Number)this.meltingPoint);
            json.add("resource", this.resource.func_200304_c());
            json.add("product", (JsonElement)RecipeSerializers.serializeFluid(this.product));
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return IFabricatorSmeltingRecipe.Companion.SERIALIZER;
        }

        public JsonObject func_200440_c() {
            return null;
        }

        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

