/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.core.tooltips.TextCollection;
import forestry.api.core.tooltips.TextCompound;
import forestry.api.core.tooltips.ToolTip;
import forestry.api.genetics.alyzer.IAlleleDisplayHelper;
import forestry.apiculture.genetics.IGeneticTooltipProvider;
import genetics.api.alleles.IAllele;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IGenome;
import genetics.api.individual.IIndividual;
import net.minecraft.util.text.TextFormatting;

public enum DefaultDisplayHandler implements IGeneticTooltipProvider<IIndividual>
{
    UNKNOWN(-3){

        @Override
        public void addTooltip(ToolTip toolTip, IGenome genome, IIndividual individual) {
            ((TextCompound)((TextCompound)((TextCompound)((TextCompound)toolTip.singleLine().text("<")).translated("for.gui.unknown", new Object[0])).text(">")).style(TextFormatting.GRAY)).create();
        }
    }
    ,
    HYBRID(-2){

        @Override
        public void addTooltip(ToolTip toolTip, IGenome genome, IIndividual individual) {
            IChromosomeType speciesType = individual.getRoot().getKaryotype().getSpeciesType();
            IAllele primary = genome.getActiveAllele(speciesType);
            IAllele secondary = genome.getInactiveAllele(speciesType);
            if (!individual.isPureBred(speciesType)) {
                ((TextCollection)toolTip.translated("for.bees.hybrid", primary.getDisplayName(), secondary.getDisplayName())).style(TextFormatting.BLUE);
            }
        }
    };

    final int tooltipIndex;

    private DefaultDisplayHandler(int tooltipIndex) {
        this.tooltipIndex = tooltipIndex;
    }

    public static void init(IAlleleDisplayHelper helper) {
        for (DefaultDisplayHandler handler : DefaultDisplayHandler.values()) {
            int tooltipIndex = handler.tooltipIndex;
            if (tooltipIndex < 0) continue;
            helper.addTooltip(handler, "rootBees", tooltipIndex * 10);
            helper.addTooltip(handler, "rootTrees", tooltipIndex * 10);
            helper.addTooltip(handler, "rootButterflies", tooltipIndex * 10);
        }
    }
}

