/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.IIndividualLiving;
import genetics.api.individual.IGenome;
import genetics.api.individual.Individual;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;

public abstract class IndividualLiving
extends Individual
implements IIndividualLiving {
    private static final String NBT_HEALTH = "Health";
    private static final String NBT_MAX_HEALTH = "MaxH";
    private int health;
    private int maxHealth;

    protected IndividualLiving(IGenome genome, @Nullable IGenome mate) {
        super(genome, mate);
    }

    protected IndividualLiving(IGenome genome, @Nullable IGenome mate, int newHealth) {
        super(genome, mate);
        this.health = this.maxHealth = newHealth;
    }

    protected IndividualLiving(CompoundNBT nbt) {
        super(nbt);
        this.health = nbt.func_74762_e(NBT_HEALTH);
        this.maxHealth = nbt.func_74762_e(NBT_MAX_HEALTH);
    }

    @Override
    public CompoundNBT write(CompoundNBT compound) {
        compound = super.write(compound);
        compound.func_74768_a(NBT_HEALTH, this.health);
        compound.func_74768_a(NBT_MAX_HEALTH, this.maxHealth);
        return compound;
    }

    @Override
    public boolean isAlive() {
        return this.health > 0;
    }

    @Override
    public int getHealth() {
        return this.health;
    }

    @Override
    public final void setHealth(int health) {
        if (health < 0) {
            health = 0;
        } else if (health > this.getMaxHealth()) {
            health = this.getMaxHealth();
        }
        this.health = health;
    }

    @Override
    public int getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public void age(World world, float lifespanModifier) {
        float ageModifier;
        if (lifespanModifier < 0.001f) {
            this.setHealth(0);
            return;
        }
        for (ageModifier = 1.0f / lifespanModifier; ageModifier > 1.0f; ageModifier -= 1.0f) {
            this.decreaseHealth();
        }
        if (world.field_73012_v.nextFloat() < ageModifier) {
            this.decreaseHealth();
        }
    }

    private void decreaseHealth() {
        if (this.health > 0) {
            this.setHealth(this.health - 1);
        }
    }
}

