/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.mojang.authlib.GameProfile;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IForestrySpeciesRoot;
import forestry.api.genetics.alleles.IAlleleForestrySpecies;
import forestry.core.genetics.mutations.EnumMutateChance;
import forestry.core.items.ItemForestry;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.Translator;
import genetics.api.GeneticsAPI;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.individual.IIndividual;
import genetics.api.mutation.IMutation;
import genetics.api.mutation.IMutationContainer;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.IRootDefinition;
import genetics.api.root.components.ComponentKeys;
import genetics.utils.AlleleUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemResearchNote
extends ItemForestry {
    private static final String NBT_ALLELE_FIRST = "AL0";
    private static final String NBT_ALLELE_SECOND = "AL1";
    private static final String NBT_ALLELE_RESULT = "RST";
    private static final String NBT_ROOT = "ROT";
    private static final String NBT_RESEARCHER = "RES";
    private static final String NBT_TYPE = "TYP";
    private static final String NBT_INNER = "INN";

    public ItemResearchNote() {
        super(new Item.Properties().func_200916_a(null));
    }

    public ITextComponent func_200295_i(ItemStack itemstack) {
        ResearchNote note = new ResearchNote(itemstack.func_77978_p());
        String researcherName = note.researcher == null ? "Sengir" : note.researcher.getName();
        return new TranslationTextComponent(this.func_77667_c(itemstack), new Object[]{researcherName});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemstack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemstack, world, list, flag);
        ResearchNote note = new ResearchNote(itemstack.func_77978_p());
        note.addTooltip(list);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return ActionResult.func_226250_c_((Object)heldItem);
        }
        ResearchNote note = new ResearchNote(heldItem.func_77978_p());
        if (note.registerResults(worldIn, playerIn)) {
            playerIn.field_71071_by.func_70298_a(playerIn.field_71071_by.field_70461_c, 1);
            NetworkUtil.inventoryChangeNotify(playerIn, playerIn.field_71070_bA);
        }
        return ActionResult.func_226248_a_((Object)heldItem);
    }

    public static class ResearchNote {
        @Nullable
        private final GameProfile researcher;
        private final EnumNoteType type;
        private final CompoundNBT inner;

        public ResearchNote(GameProfile researcher, EnumNoteType type, CompoundNBT inner) {
            this.researcher = researcher;
            this.type = type;
            this.inner = inner;
        }

        public ResearchNote(@Nullable CompoundNBT compound) {
            if (compound != null) {
                this.researcher = compound.func_74764_b(ItemResearchNote.NBT_RESEARCHER) ? NBTUtil.func_152459_a((CompoundNBT)compound.func_74775_l(ItemResearchNote.NBT_RESEARCHER)) : null;
                this.type = EnumNoteType.VALUES[compound.func_74771_c(ItemResearchNote.NBT_TYPE)];
                this.inner = compound.func_74775_l(ItemResearchNote.NBT_INNER);
            } else {
                this.type = EnumNoteType.NONE;
                this.researcher = null;
                this.inner = new CompoundNBT();
            }
        }

        public CompoundNBT writeToNBT(CompoundNBT compound) {
            if (this.researcher != null) {
                CompoundNBT nbt = new CompoundNBT();
                NBTUtil.func_180708_a((CompoundNBT)nbt, (GameProfile)this.researcher);
                compound.func_218657_a(ItemResearchNote.NBT_RESEARCHER, (INBT)nbt);
            }
            compound.func_74774_a(ItemResearchNote.NBT_TYPE, (byte)this.type.ordinal());
            compound.func_218657_a(ItemResearchNote.NBT_INNER, (INBT)this.inner);
            return compound;
        }

        public void addTooltip(List<ITextComponent> list) {
            List<ITextComponent> tooltips = this.type.getTooltip(this.inner);
            if (tooltips.isEmpty()) {
                list.add((ITextComponent)new TranslationTextComponent("for.researchNote.error.0").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.ITALIC}));
                list.add((ITextComponent)new TranslationTextComponent("for.researchNote.error.1"));
                return;
            }
            list.addAll(tooltips);
        }

        public boolean registerResults(World world, PlayerEntity player) {
            return this.type.registerResults(world, player, this.inner);
        }
    }

    public static enum EnumNoteType {
        NONE,
        MUTATION,
        SPECIES;

        public static final EnumNoteType[] VALUES;

        @Nullable
        private static IMutation getEncodedMutation(IIndividualRoot<IIndividual> root, CompoundNBT compound) {
            Object allele0 = AlleleUtils.getAlleleOrNull(compound.func_74779_i(ItemResearchNote.NBT_ALLELE_FIRST));
            Object allele1 = AlleleUtils.getAlleleOrNull(compound.func_74779_i(ItemResearchNote.NBT_ALLELE_SECOND));
            if (allele0 == null || allele1 == null) {
                return null;
            }
            IAllele result = null;
            if (compound.func_74764_b(ItemResearchNote.NBT_ALLELE_RESULT)) {
                result = (IAllele)AlleleUtils.getAlleleOrNull(compound.func_74779_i(ItemResearchNote.NBT_ALLELE_RESULT));
            }
            IMutation encoded = null;
            IMutationContainer container = (IMutationContainer)root.getComponent(ComponentKeys.MUTATIONS);
            for (IMutation mutation : container.getCombinations((IAllele)allele0)) {
                if (!mutation.isPartner((IAllele)allele1) || result != null && !mutation.getTemplate()[0].getRegistryName().equals((Object)result.getRegistryName())) continue;
                encoded = mutation;
                break;
            }
            return encoded;
        }

        public List<ITextComponent> getTooltip(CompoundNBT compound) {
            ArrayList<ITextComponent> tooltips = new ArrayList<ITextComponent>();
            if (this == NONE) {
                return tooltips;
            }
            if (this == MUTATION) {
                IRootDefinition definition = GeneticsAPI.apiInstance.getRoot(compound.func_74779_i(ItemResearchNote.NBT_ROOT));
                if (!definition.isPresent()) {
                    return tooltips;
                }
                Object root2 = definition.get();
                IMutation encoded = EnumNoteType.getEncodedMutation(root2, compound);
                if (encoded == null) {
                    return tooltips;
                }
                ITextComponent species1 = encoded.getFirstParent().getDisplayName();
                ITextComponent species2 = encoded.getSecondParent().getDisplayName();
                String mutationChanceKey = EnumMutateChance.rateChance(encoded.getBaseChance()).toString().toLowerCase(Locale.ENGLISH);
                String mutationChance = Translator.translateToLocal("for.researchNote.chance." + mutationChanceKey);
                ITextComponent speciesResult = encoded.getResultingSpecies().getDisplayName();
                tooltips.add((ITextComponent)new TranslationTextComponent("for.researchNote.discovery.0"));
                tooltips.add((ITextComponent)new TranslationTextComponent("for.researchNote.discovery.1", new Object[]{species1, species2}));
                tooltips.add((ITextComponent)new TranslationTextComponent("for.researchNote.discovery.2", new Object[]{mutationChance}));
                tooltips.add((ITextComponent)new TranslationTextComponent("for.researchNote.discovery.3", new Object[]{speciesResult}));
                if (!encoded.getSpecialConditions().isEmpty()) {
                    for (ITextComponent line : encoded.getSpecialConditions()) {
                        tooltips.add((ITextComponent)((IFormattableTextComponent)line).func_240699_a_(TextFormatting.GOLD));
                    }
                }
            } else if (this == SPECIES) {
                IAlleleForestrySpecies alleleFirst = (IAlleleForestrySpecies)AlleleUtils.getAlleleOrNull(compound.func_74779_i(ItemResearchNote.NBT_ALLELE_FIRST));
                if (alleleFirst == null) {
                    return tooltips;
                }
                IRootDefinition<IIndividualRoot> definition = GeneticsAPI.apiInstance.getRoot(compound.func_74779_i(ItemResearchNote.NBT_ROOT));
                definition.ifPresent(root -> {
                    tooltips.add((ITextComponent)new TranslationTextComponent("researchNote.discovered.0"));
                    tooltips.add((ITextComponent)new TranslationTextComponent("for.researchNote.discovered.1", new Object[]{alleleFirst.getDisplayName(), alleleFirst.getBinomial()}));
                });
            }
            return tooltips;
        }

        public boolean registerResults(World world, PlayerEntity player, CompoundNBT compound) {
            if (this == NONE) {
                return false;
            }
            if (this == MUTATION) {
                IRootDefinition definition = GeneticsAPI.apiInstance.getRoot(compound.func_74779_i(ItemResearchNote.NBT_ROOT));
                if (!definition.isPresent()) {
                    return false;
                }
                Object root = definition.get();
                IMutation encoded = EnumNoteType.getEncodedMutation(root, compound);
                if (encoded == null) {
                    return false;
                }
                IBreedingTracker tracker = ((IForestrySpeciesRoot)encoded.getRoot()).getBreedingTracker((IWorld)world, player.func_146103_bH());
                if (tracker.isResearched(encoded)) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("for.chat.cannotmemorizeagain"), Util.field_240973_b_);
                    return false;
                }
                IAlleleSpecies speciesFirst = encoded.getFirstParent();
                IAlleleSpecies speciesSecond = encoded.getSecondParent();
                IAlleleSpecies speciesResult = encoded.getResultingSpecies();
                tracker.registerSpecies(speciesFirst);
                tracker.registerSpecies(speciesSecond);
                tracker.registerSpecies(speciesResult);
                tracker.researchMutation(encoded);
                player.func_145747_a((ITextComponent)new TranslationTextComponent("for.chat.memorizednote"), Util.field_240973_b_);
                player.func_145747_a((ITextComponent)new TranslationTextComponent("for.chat.memorizednote2", new Object[]{((IFormattableTextComponent)speciesFirst.getDisplayName()).func_240699_a_(TextFormatting.GRAY), ((IFormattableTextComponent)speciesSecond.getDisplayName()).func_240699_a_(TextFormatting.GRAY), ((IFormattableTextComponent)speciesResult.getDisplayName()).func_240699_a_(TextFormatting.GREEN)}), Util.field_240973_b_);
                return true;
            }
            return false;
        }

        public static ResearchNote createMutationNote(GameProfile researcher, IMutation mutation) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74778_a(ItemResearchNote.NBT_ROOT, mutation.getRoot().getUID());
            compound.func_74778_a(ItemResearchNote.NBT_ALLELE_FIRST, mutation.getFirstParent().getRegistryName().toString());
            compound.func_74778_a(ItemResearchNote.NBT_ALLELE_SECOND, mutation.getSecondParent().getRegistryName().toString());
            compound.func_74778_a(ItemResearchNote.NBT_ALLELE_RESULT, mutation.getResultingSpecies().getRegistryName().toString());
            return new ResearchNote(researcher, MUTATION, compound);
        }

        public static ItemStack createMutationNoteStack(Item item, GameProfile researcher, IMutation mutation) {
            ResearchNote note = EnumNoteType.createMutationNote(researcher, mutation);
            CompoundNBT compound = new CompoundNBT();
            note.writeToNBT(compound);
            ItemStack created = new ItemStack((IItemProvider)item);
            created.func_77982_d(compound);
            return created;
        }

        public static ResearchNote createSpeciesNote(GameProfile researcher, IAlleleForestrySpecies species) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74778_a(ItemResearchNote.NBT_ROOT, species.getRoot().getUID());
            compound.func_74778_a(ItemResearchNote.NBT_ALLELE_FIRST, species.getRegistryName().toString());
            return new ResearchNote(researcher, SPECIES, compound);
        }

        public static ItemStack createSpeciesNoteStack(Item item, GameProfile researcher, IAlleleForestrySpecies species) {
            ResearchNote note = EnumNoteType.createSpeciesNote(researcher, species);
            CompoundNBT compound = new CompoundNBT();
            note.writeToNBT(compound);
            ItemStack created = new ItemStack((IItemProvider)item);
            created.func_77982_d(compound);
            return created;
        }

        static {
            VALUES = EnumNoteType.values();
        }
    }
}

