/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.alleles;

import com.google.common.base.Preconditions;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.alleles.IAlleleForestrySpecies;
import forestry.api.genetics.alleles.IAlleleSpeciesBuilder;
import forestry.core.utils.GeneticsUtil;
import genetics.api.alleles.Allele;
import genetics.api.classification.IClassification;
import genetics.api.organism.IOrganismType;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class AlleleForestrySpecies
extends Allele
implements IAlleleForestrySpecies {
    private final String binomial;
    private final String authority;
    private final String description;
    private final String speciesIdentifier;
    private final IClassification branch;
    private final boolean hasEffect;
    private final boolean isSecret;
    private final boolean isCounted;
    private final EnumTemperature climate;
    private final EnumHumidity humidity;
    @Nullable
    private final Integer complexityOverride;

    protected AlleleForestrySpecies(AbstractBuilder<?> builder) {
        super(((AbstractBuilder)builder).translationKey, ((AbstractBuilder)builder).isDominant);
        this.setRegistryName(new ResourceLocation(((AbstractBuilder)builder).modId, ((AbstractBuilder)builder).uid));
        this.binomial = ((AbstractBuilder)builder).binomial;
        this.authority = ((AbstractBuilder)builder).authority;
        this.description = ((AbstractBuilder)builder).description;
        this.speciesIdentifier = ((AbstractBuilder)builder).speciesIdentifier;
        this.branch = ((AbstractBuilder)builder).branch;
        this.hasEffect = ((AbstractBuilder)builder).hasEffect;
        this.isSecret = ((AbstractBuilder)builder).isSecret;
        this.isCounted = ((AbstractBuilder)builder).isCounted;
        this.climate = ((AbstractBuilder)builder).climate;
        this.humidity = ((AbstractBuilder)builder).humidity;
        this.complexityOverride = ((AbstractBuilder)builder).complexityOverride;
    }

    @Override
    public ITextComponent getItemName(IOrganismType type) {
        return GeneticsUtil.getItemName(type, this);
    }

    @Override
    public ITextComponent getAlyzerName(IOrganismType type) {
        return GeneticsUtil.getAlyzerName(type, this);
    }

    @Override
    public ITextComponent getDescription() {
        return new TranslationTextComponent(this.description);
    }

    @Override
    public int getComplexity() {
        if (this.complexityOverride != null) {
            return this.complexityOverride;
        }
        return GeneticsUtil.getResearchComplexity(this, this.getRoot().getKaryotype().getSpeciesType());
    }

    @Override
    public EnumTemperature getTemperature() {
        return this.climate;
    }

    @Override
    public EnumHumidity getHumidity() {
        return this.humidity;
    }

    @Override
    public boolean hasEffect() {
        return this.hasEffect;
    }

    @Override
    public boolean isSecret() {
        return this.isSecret;
    }

    @Override
    public boolean isCounted() {
        return this.isCounted;
    }

    @Override
    public String getBinomial() {
        return this.binomial;
    }

    @Override
    public String getSpeciesIdentifier() {
        return this.speciesIdentifier;
    }

    @Override
    public String getAuthority() {
        return this.authority;
    }

    @Override
    public IClassification getBranch() {
        return this.branch;
    }

    protected String getModID() {
        return this.getRegistryName().func_110624_b();
    }

    public static abstract class AbstractBuilder<B extends IAlleleSpeciesBuilder<?>>
    implements IAlleleSpeciesBuilder<B> {
        private final String modId;
        private final String uid;
        private final String speciesIdentifier;
        private String translationKey;
        private String binomial;
        private String authority = "Sengir";
        private String description = "";
        private IClassification branch;
        private boolean hasEffect = false;
        private boolean isSecret = false;
        private boolean isCounted = true;
        private boolean isDominant = false;
        private EnumTemperature climate = EnumTemperature.NORMAL;
        private EnumHumidity humidity = EnumHumidity.NORMAL;
        @Nullable
        private Integer complexityOverride = null;

        protected AbstractBuilder(String modId, String uid, String speciesIdentifier) {
            this.modId = modId;
            this.uid = uid;
            this.speciesIdentifier = speciesIdentifier;
        }

        protected static void checkBuilder(AbstractBuilder<?> builder) {
            Preconditions.checkNotNull((Object)builder.branch, (Object)"Every forestry species needs a branch");
            Preconditions.checkNotNull((Object)builder.translationKey);
            Preconditions.checkNotNull((Object)builder.binomial);
        }

        @Override
        public B setDominant(boolean isDominant) {
            this.isDominant = isDominant;
            return (B)((IAlleleSpeciesBuilder)this.cast());
        }

        @Override
        public B setAuthority(String authority) {
            this.authority = authority;
            return (B)((IAlleleSpeciesBuilder)this.cast());
        }

        @Override
        public B setBinomial(String binomial) {
            this.binomial = binomial;
            return (B)((IAlleleSpeciesBuilder)this.cast());
        }

        @Override
        public B setBranch(IClassification branch) {
            this.branch = branch;
            return (B)((IAlleleSpeciesBuilder)this.cast());
        }

        @Override
        public B setDescriptionKey(String description) {
            this.description = description;
            return (B)((IAlleleSpeciesBuilder)this.cast());
        }

        @Override
        public B setTranslationKey(String translationKey) {
            this.translationKey = translationKey;
            return (B)((IAlleleSpeciesBuilder)this.cast());
        }

        @Override
        public B setComplexity(int complexity) {
            this.complexityOverride = complexity;
            return (B)((IAlleleSpeciesBuilder)this.cast());
        }

        @Override
        public B setTemperature(EnumTemperature temperature) {
            this.climate = temperature;
            return (B)((IAlleleSpeciesBuilder)this.cast());
        }

        @Override
        public B setHumidity(EnumHumidity humidity) {
            this.humidity = humidity;
            return (B)((IAlleleSpeciesBuilder)this.cast());
        }

        @Override
        public B setHasEffect() {
            this.hasEffect = true;
            return (B)((IAlleleSpeciesBuilder)this.cast());
        }

        @Override
        public B setIsSecret() {
            this.isSecret = true;
            return (B)((IAlleleSpeciesBuilder)this.cast());
        }

        @Override
        public B setIsNotCounted() {
            this.isCounted = false;
            return (B)((IAlleleSpeciesBuilder)this.cast());
        }
    }
}

