/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.mutations;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.climate.IClimateProvider;
import forestry.api.genetics.IMutationCondition;
import forestry.core.tiles.TileUtil;
import genetics.api.alleles.IAllele;
import genetics.api.individual.IGenome;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MutationConditionRequiresResource
implements IMutationCondition {
    private final List<BlockState> acceptedBlockStates;

    public MutationConditionRequiresResource(BlockState ... acceptedBlockStates) {
        this.acceptedBlockStates = Arrays.asList(acceptedBlockStates);
    }

    @Override
    public float getChance(World world, BlockPos pos, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1, IClimateProvider climate) {
        TileEntity tile;
        while ((tile = TileUtil.getTile((IBlockReader)world, pos = pos.func_177977_b())) instanceof IBeeHousing) {
        }
        BlockState blockState = world.func_180495_p(pos);
        return this.acceptedBlockStates.contains(blockState) ? 1.0f : 0.0f;
    }

    @Override
    public ITextComponent getDescription() {
        if (this.acceptedBlockStates.isEmpty()) {
            return NarratorChatListener.field_216868_a;
        }
        return new TranslationTextComponent("for.mutation.condition.resource", new Object[]{this.acceptedBlockStates.get(0).func_177230_c().func_235333_g_()});
    }
}

