/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.root;

import com.mojang.authlib.GameProfile;
import forestry.api.genetics.ForestryComponentKeys;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IForestrySpeciesRoot;
import forestry.api.genetics.IResearchHandler;
import forestry.api.genetics.alleles.AlleleManager;
import forestry.core.genetics.root.IResearchPlugin;
import forestry.core.utils.ItemStackUtil;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.individual.IIndividual;
import genetics.api.mutation.IMutation;
import genetics.api.mutation.IMutationContainer;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.components.ComponentKey;
import genetics.api.root.components.ComponentKeys;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ResearchHandler<I extends IIndividual>
implements IResearchHandler<I> {
    private final Map<ItemStack, Float> catalysts = new LinkedHashMap<ItemStack, Float>();
    private final List<IResearchPlugin> plugins = new LinkedList<IResearchPlugin>();
    private final IIndividualRoot<I> root;

    public ResearchHandler(IIndividualRoot<I> root) {
        this.root = root;
    }

    @Override
    public IIndividualRoot<I> getRoot() {
        return this.root;
    }

    @Override
    public void setResearchSuitability(ItemStack stack, float suitability) {
        this.catalysts.put(stack, Float.valueOf(suitability));
    }

    @Override
    public void addPlugin(IResearchPlugin plugin) {
        this.plugins.add(plugin);
    }

    @Override
    public Map<ItemStack, Float> getResearchCatalysts() {
        return this.catalysts;
    }

    @Override
    public float getResearchSuitability(IAlleleSpecies species, ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return 0.0f;
        }
        for (IResearchPlugin iResearchPlugin : this.plugins) {
            float suitability = iResearchPlugin.getResearchSuitability(species, itemstack);
            if (suitability < 0.0f) continue;
            return suitability;
        }
        if (this.root.isMember(itemstack)) {
            return 1.0f;
        }
        for (Map.Entry entry : this.catalysts.entrySet()) {
            if (!ItemStackUtil.isIdenticalItem((ItemStack)entry.getKey(), itemstack)) continue;
            return ((Float)entry.getValue()).floatValue();
        }
        return 0.0f;
    }

    @Override
    public NonNullList<ItemStack> getResearchBounty(IAlleleSpecies species, World world, GameProfile gameProfile, I individual, int bountyLevel) {
        IMutationContainer container;
        List allMutations;
        NonNullList bounty = NonNullList.func_191196_a();
        if (world.field_73012_v.nextFloat() < (float)bountyLevel / 16.0f && !(allMutations = (container = (IMutationContainer)this.root.getComponent(ComponentKeys.MUTATIONS)).getCombinations(species)).isEmpty()) {
            ArrayList<IMutation> unresearchedMutations = new ArrayList<IMutation>();
            IBreedingTracker tracker = ((IForestrySpeciesRoot)this.root).getBreedingTracker((IWorld)world, gameProfile);
            for (IMutation mutation : allMutations) {
                if (tracker.isResearched(mutation)) continue;
                unresearchedMutations.add(mutation);
            }
            IMutation chosenMutation = !unresearchedMutations.isEmpty() ? (IMutation)unresearchedMutations.get(world.field_73012_v.nextInt(unresearchedMutations.size())) : (IMutation)allMutations.get(world.field_73012_v.nextInt(allMutations.size()));
            ItemStack researchNote = AlleleManager.geneticRegistry.getMutationNoteStack(gameProfile, chosenMutation);
            bounty.add((Object)researchNote);
        }
        this.plugins.forEach(plugin -> bounty.addAll(plugin.getResearchBounty(species, world, gameProfile, (IIndividual)individual, bountyLevel)));
        return bounty;
    }

    @Override
    public ComponentKey<IResearchHandler> getKey() {
        return ForestryComponentKeys.RESEARCH;
    }
}

