/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.features.CoreContainers;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.ContainerTile;
import forestry.core.gui.IGuiSelectable;
import forestry.core.gui.slots.SlotFilteredInventory;
import forestry.core.tiles.IFilterSlotDelegate;
import forestry.core.tiles.TileNaturalistChest;
import forestry.core.tiles.TileUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IBlockReader;

public class ContainerNaturalistInventory
extends ContainerTile<TileNaturalistChest>
implements IGuiSelectable {
    private int page;
    private int maxPage;

    public static ContainerNaturalistInventory fromNetwork(int windowId, PlayerInventory playerInv, PacketBuffer extraData) {
        TileNaturalistChest tile = TileUtil.getTile((IBlockReader)playerInv.field_70458_d.field_70170_p, extraData.func_179259_c(), TileNaturalistChest.class);
        return new ContainerNaturalistInventory(windowId, playerInv, tile, extraData.func_150792_a());
    }

    public ContainerNaturalistInventory(int windowId, PlayerInventory player, TileNaturalistChest tile, int page) {
        super(windowId, CoreContainers.NATURALIST_INVENTORY.containerType(), player, tile, 18, 120);
        this.page = page;
        this.maxPage = 5;
        ContainerNaturalistInventory.addInventory(this, tile, page);
    }

    public static <T extends IInventory & IFilterSlotDelegate> void addInventory(ContainerForestry container, T inventory, int selectedPage) {
        for (int page = 0; page < 5; ++page) {
            for (int x = 0; x < 5; ++x) {
                for (int y = 0; y < 5; ++y) {
                    int slot = y + page * 25 + x * 5;
                    if (page == selectedPage) {
                        container.func_75146_a(new SlotFilteredInventory(inventory, slot, 100 + y * 18, 21 + x * 18));
                        continue;
                    }
                    container.func_75146_a(new SlotFilteredInventory(inventory, slot, -10000, -10000));
                }
            }
        }
    }

    @Override
    public void handleSelectionRequest(ServerPlayerEntity player, int primary, int secondary) {
        ((TileNaturalistChest)this.tile).flipPage(player, (short)primary);
    }

    public int getPage() {
        return this.page;
    }

    public int getMaxPage() {
        return this.maxPage;
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        ((TileNaturalistChest)this.tile).increaseNumPlayersUsing();
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        ((TileNaturalistChest)this.tile).decreaseNumPlayersUsing();
    }
}

