/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IForestrySpeciesRoot;
import forestry.core.genetics.mutations.EnumMutateChance;
import forestry.core.gui.ContainerNaturalistInventory;
import forestry.core.gui.CycleTimer;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.buttons.GuiBetterButton;
import forestry.core.gui.buttons.StandardButtonTextureSets;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.render.ColourProperties;
import forestry.core.tiles.TileNaturalistChest;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.Translator;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IGenome;
import genetics.api.individual.IIndividual;
import genetics.api.mutation.IMutation;
import genetics.api.mutation.IMutationContainer;
import genetics.api.root.components.ComponentKeys;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;

public class GuiNaturalistInventory
extends GuiForestry<ContainerNaturalistInventory> {
    private final IForestrySpeciesRoot<IIndividual> speciesRoot;
    private final IBreedingTracker breedingTracker;
    private final HashMap<String, ItemStack> iconStacks = new HashMap();
    private final int pageCurrent;
    private final int pageMax;
    private final CycleTimer timer = new CycleTimer(0);

    public GuiNaturalistInventory(ContainerNaturalistInventory container, PlayerInventory playerInv, ITextComponent name) {
        super("textures/gui/apiaristinventory.png", container, playerInv, name);
        this.speciesRoot = ((TileNaturalistChest)container.tile).getSpeciesRoot();
        this.pageCurrent = container.getPage();
        this.pageMax = container.getMaxPage();
        this.field_146999_f = 196;
        this.field_147000_g = 202;
        for (IIndividual individual : this.speciesRoot.getIndividualTemplates()) {
            this.iconStacks.put(individual.getIdentifier(), this.speciesRoot.getTypes().createStack(individual, this.speciesRoot.getIconType()));
        }
        this.breedingTracker = this.speciesRoot.getBreedingTracker((IWorld)playerInv.field_70458_d.field_70170_p, playerInv.field_70458_d.func_146103_bH());
    }

    @Override
    protected void func_230450_a_(MatrixStack transform, float partialTicks, int j, int i) {
        super.func_230450_a_(transform, partialTicks, j, i);
        this.timer.onDraw();
        String header = Translator.translateToLocal("for.gui.page") + " " + (this.pageCurrent + 1) + "/" + this.pageMax;
        this.getFontRenderer().func_238421_b_(transform, header, (float)(this.field_147003_i + 95 + this.textLayout.getCenteredOffset(header, 98)), (float)(this.field_147009_r + 10), ColourProperties.INSTANCE.get("gui.title"));
        IIndividual individual = this.getIndividualAtPosition(i, j);
        if (individual == null) {
            this.displayBreedingStatistics(transform, 10);
        }
        if (individual != null) {
            this.textLayout.startPage();
            IGenome genome = individual.getGenome();
            IChromosomeType speciesType = individual.getRoot().getKaryotype().getSpeciesType();
            boolean pureBred = individual.isPureBred(speciesType);
            this.displaySpeciesInformation(transform, true, genome.getPrimary(), this.iconStacks.get(individual.getIdentifier()), 10, pureBred ? 25 : 10);
            if (!pureBred) {
                this.displaySpeciesInformation(transform, individual.isAnalyzed(), genome.getSecondary(), this.iconStacks.get(genome.getSecondary().getRegistryName().toString()), 10, 10);
            }
            this.textLayout.endPage();
        }
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new GuiBetterButton(this.field_147003_i + 99, this.field_147009_r + 7, StandardButtonTextureSets.LEFT_BUTTON_SMALL, b -> {
            if (this.pageCurrent > 0) {
                GuiNaturalistInventory.flipPage(this.pageCurrent - 1);
            }
        }));
        this.func_230480_a_((Widget)new GuiBetterButton(this.field_147003_i + 180, this.field_147009_r + 7, StandardButtonTextureSets.RIGHT_BUTTON_SMALL, b -> {
            if (this.pageCurrent < this.pageMax - 1) {
                GuiNaturalistInventory.flipPage(this.pageCurrent + 1);
            }
        }));
    }

    private static void flipPage(int page) {
        NetworkUtil.sendToServer(new PacketGuiSelectRequest(page, 0));
    }

    @Nullable
    private IIndividual getIndividualAtPosition(int x, int y) {
        Slot slot = this.getSlotAtPosition(x, y);
        if (slot == null) {
            return null;
        }
        if (!slot.func_75216_d()) {
            return null;
        }
        if (!slot.func_75211_c().func_77942_o()) {
            return null;
        }
        if (!this.speciesRoot.isMember(slot.func_75211_c())) {
            return null;
        }
        return this.speciesRoot.getTypes().createIndividual(slot.func_75211_c()).orElse(null);
    }

    private void displayBreedingStatistics(MatrixStack transform, int x) {
        this.textLayout.startPage();
        this.textLayout.drawLine(transform, Translator.translateToLocal("for.gui.speciescount") + ": " + this.breedingTracker.getSpeciesBred() + "/" + this.speciesRoot.getSpeciesCount(), x);
        this.textLayout.newLine();
        this.textLayout.newLine();
        if (this.breedingTracker instanceof IApiaristTracker) {
            IApiaristTracker tracker = (IApiaristTracker)this.breedingTracker;
            this.textLayout.drawLine(transform, Translator.translateToLocal("for.gui.queens") + ": " + tracker.getQueenCount(), x);
            this.textLayout.newLine();
            this.textLayout.drawLine(transform, Translator.translateToLocal("for.gui.princesses") + ": " + tracker.getPrincessCount(), x);
            this.textLayout.newLine();
            this.textLayout.drawLine(transform, Translator.translateToLocal("for.gui.drones") + ": " + tracker.getDroneCount(), x);
            this.textLayout.newLine();
        }
        this.textLayout.endPage();
    }

    private void displaySpeciesInformation(MatrixStack transform, boolean analyzed, IAlleleSpecies species, ItemStack iconStack, int x, int maxMutationCount) {
        if (!analyzed) {
            this.textLayout.drawLine(transform, Translator.translateToLocal("for.gui.unknown"), x);
            return;
        }
        this.textLayout.drawLine(transform, species.getDisplayName().getString(), x);
        GuiUtil.drawItemStack(this, iconStack, this.field_147003_i + x + 69, this.field_147009_r + this.textLayout.getLineY() - 2);
        this.textLayout.newLine();
        int columnWidth = 16;
        int column = 10;
        IMutationContainer container = (IMutationContainer)this.speciesRoot.getComponent(ComponentKeys.MUTATIONS);
        List<List<? extends IMutation>> mutations = GuiNaturalistInventory.splitMutations(container.getCombinations(species), maxMutationCount);
        for (IMutation combination : this.timer.getCycledItem(mutations, Collections::emptyList)) {
            if (combination.isSecret()) continue;
            if (this.breedingTracker.isDiscovered(combination)) {
                this.drawMutationIcon(transform, combination, species, column);
            } else {
                this.drawUnknownIcon(transform, combination, column);
            }
            if ((column += columnWidth) <= 75) continue;
            column = 10;
            this.textLayout.newLine(18);
        }
        this.textLayout.newLine();
        this.textLayout.newLine();
    }

    private void drawMutationIcon(MatrixStack transform, IMutation combination, IAlleleSpecies species, int x) {
        int column;
        GuiUtil.drawItemStack(this, this.iconStacks.get(combination.getPartner(species).getRegistryName().toString()), this.field_147003_i + x, this.field_147009_r + this.textLayout.getLineY());
        int line = 48;
        EnumMutateChance chance = EnumMutateChance.rateChance(combination.getBaseChance());
        if (chance == EnumMutateChance.HIGHEST) {
            line += 16;
            column = 228;
        } else if (chance == EnumMutateChance.HIGHER) {
            line += 16;
            column = 212;
        } else if (chance == EnumMutateChance.HIGH) {
            line += 16;
            column = 196;
        } else if (chance == EnumMutateChance.NORMAL) {
            line += 0;
            column = 228;
        } else if (chance == EnumMutateChance.LOW) {
            line += 0;
            column = 212;
        } else {
            line += 0;
            column = 196;
        }
        this.bindTexture(this.textureFile);
        this.func_238474_b_(transform, this.field_147003_i + x, this.field_147009_r + this.textLayout.getLineY(), column, line, 16, 16);
    }

    private void drawUnknownIcon(MatrixStack transform, IMutation mutation, int x) {
        int column;
        int line;
        float chance = mutation.getBaseChance();
        if (chance >= 20.0f) {
            line = 16;
            column = 228;
        } else if (chance >= 15.0f) {
            line = 16;
            column = 212;
        } else if (chance >= 12.0f) {
            line = 16;
            column = 196;
        } else if (chance >= 10.0f) {
            line = 0;
            column = 228;
        } else if (chance >= 5.0f) {
            line = 0;
            column = 212;
        } else {
            line = 0;
            column = 196;
        }
        this.bindTexture(this.textureFile);
        this.func_238474_b_(transform, this.field_147003_i + x, this.field_147009_r + this.textLayout.getLineY(), column, line, 16, 16);
    }

    private static List<List<? extends IMutation>> splitMutations(List<? extends IMutation> mutations, int maxMutationCount) {
        int size = mutations.size();
        if (size <= maxMutationCount) {
            return Collections.singletonList(mutations);
        }
        ImmutableList.Builder subGroups = new ImmutableList.Builder();
        LinkedList<IMutation> subList = new LinkedList<IMutation>();
        subGroups.add(subList);
        int count = 0;
        for (IMutation iMutation : mutations) {
            if (iMutation.isSecret()) continue;
            if (count % maxMutationCount == 0 && count != 0) {
                subList = new LinkedList();
                subGroups.add(subList);
            }
            subList.add(iMutation);
            ++count;
        }
        return subGroups.build();
    }

    @Override
    protected void addLedgers() {
        this.addHintLedger("naturalist.chest");
    }
}

