/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.core.tooltips.IToolTipProvider;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.IGuiSizable;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;

@OnlyIn(value=Dist.CLIENT)
public class GuiUtil {
    public static void drawItemStack(GuiForestry gui, ItemStack stack, int xPos, int yPos) {
        GuiUtil.drawItemStack(gui.getFontRenderer(), stack, xPos, yPos);
    }

    public static void drawItemStack(FontRenderer fontRenderer, ItemStack stack, int xPos, int yPos) {
        FontRenderer font = null;
        if (!stack.func_190926_b()) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = fontRenderer;
        }
        ItemRenderer itemRender = Minecraft.func_71410_x().func_175599_af();
        itemRender.func_180450_b(stack, xPos, yPos);
        itemRender.func_180453_a(font, stack, xPos, yPos, null);
    }

    public static void drawToolTips(MatrixStack transform, IGuiSizable gui, @Nullable IToolTipProvider provider, ToolTip toolTips, int mouseX, int mouseY) {
        if (!toolTips.isEmpty()) {
            RenderSystem.pushMatrix();
            if (provider == null || provider.isRelativeToGui()) {
                RenderSystem.translatef((float)(-gui.getGuiLeft()), (float)(-gui.getGuiTop()), (float)0.0f);
            }
            MainWindow window = Minecraft.func_71410_x().func_228018_at_();
            GuiUtils.drawHoveringText((MatrixStack)transform, toolTips.getLines(), (int)mouseX, (int)mouseY, (int)window.func_198107_o(), (int)window.func_198087_p(), (int)-1, (FontRenderer)gui.getGameInstance().field_71466_p);
            RenderSystem.popMatrix();
        }
    }

    public static void drawToolTips(MatrixStack transform, IGuiSizable gui, Collection<?> objects, int mouseX, int mouseY) {
        for (Object obj : objects) {
            ToolTip tips;
            IToolTipProvider provider;
            if (!(obj instanceof IToolTipProvider) || !(provider = (IToolTipProvider)obj).isToolTipVisible()) continue;
            int mX = mouseX;
            int mY = mouseY;
            if (provider.isRelativeToGui()) {
                mX -= gui.getGuiLeft();
                mY -= gui.getGuiTop();
            }
            if ((tips = provider.getToolTip(mX, mY)) == null) continue;
            boolean mouseOver = provider.isHovering(mX, mY);
            tips.onTick(mouseOver);
            if (!mouseOver || !tips.isReady()) continue;
            tips.refresh();
            GuiUtil.drawToolTips(transform, gui, provider, tips, mouseX, mouseY);
        }
    }

    public static void enableUnicode() {
        Minecraft instance = Minecraft.func_71410_x();
        instance.func_238209_b_(true);
    }

    public static void resetUnicode() {
        Minecraft instance = Minecraft.func_71410_x();
        instance.func_238209_b_(instance.func_211821_e());
    }

    public static void showScreen(Screen screen) {
        Minecraft instance = Minecraft.func_71410_x();
        instance.func_147108_a(screen);
    }
}

