/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.core.tooltips.TextCollection;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.gui.Drawable;
import forestry.core.gui.elements.GuiElement;
import forestry.core.utils.ResourceUtil;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class TankElement
extends GuiElement {
    @Nullable
    private final Drawable background;
    @Nullable
    private final Drawable overlay;
    private final FluidStack contents;
    private final int capacity;

    public TankElement(int xPos, int yPos, @Nullable Drawable background, FluidStack contents, int capacity) {
        this(xPos, yPos, background, contents, capacity, null);
    }

    public TankElement(int xPos, int yPos, @Nullable Drawable background, FluidStack contents, int capacity, @Nullable Drawable overlay) {
        this(xPos, yPos, background, contents, capacity, overlay, 16, 58);
    }

    public TankElement(int xPos, int yPos, @Nullable Drawable background, FluidStack contents, int capacity, @Nullable Drawable overlay, int width, int height) {
        super(xPos, yPos, width, height);
        this.background = background;
        this.contents = contents;
        this.capacity = capacity;
        this.overlay = overlay;
        this.addTooltip((ToolTip tooltip, GuiElement element, int mouseX, int mouseY) -> {
            ToolTip toolTip = new ToolTip();
            int amount = contents.getAmount();
            Fluid fluidType = contents.getFluid();
            FluidAttributes attributes = fluidType.getAttributes();
            Rarity rarity = attributes.getRarity(contents);
            if (rarity == null) {
                rarity = Rarity.COMMON;
            }
            ((TextCollection)toolTip.translated(attributes.getTranslationKey(contents), new Object[0])).style(rarity.field_77937_e);
            toolTip.translated("for.gui.tooltip.liquid.amount", amount, capacity);
        });
    }

    @Override
    public void drawElement(MatrixStack transform, int mouseX, int mouseY) {
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        if (this.background != null) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.background.draw(transform, 0, 0);
        }
        if (this.contents.isEmpty() || this.capacity <= 0) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        TextureManager textureManager = minecraft.func_110434_K();
        if (this.contents.getAmount() > 0 && this.contents.getFluid() != null) {
            Fluid fluid = this.contents.getFluid();
            FluidAttributes attributes = fluid.getAttributes();
            ResourceLocation fluidStill = fluid.getAttributes().getStillTexture(this.contents);
            TextureAtlasSprite fluidStillSprite = null;
            if (fluidStill != null) {
                fluidStillSprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidStill);
            }
            if (fluidStillSprite == null) {
                fluidStillSprite = ResourceUtil.getMissingTexture();
            }
            int fluidColor = attributes.getColor(this.contents);
            int scaledAmount = this.contents.getAmount() * this.getHeight() / this.capacity;
            if (this.contents.getAmount() > 0 && scaledAmount < 1) {
                scaledAmount = 1;
            }
            if (scaledAmount > this.getHeight()) {
                scaledAmount = this.getHeight();
            }
            textureManager.func_110577_a(AtlasTexture.field_110575_b);
            TankElement.setGLColorFromInt(fluidColor);
            int xTileCount = this.getWidth() / 16;
            int xRemainder = this.getWidth() - xTileCount * 16;
            int yTileCount = scaledAmount / 16;
            int yRemainder = scaledAmount - yTileCount * 16;
            int yStart = this.getHeight();
            for (int xTile = 0; xTile <= xTileCount; ++xTile) {
                for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                    int width = xTile == xTileCount ? xRemainder : 16;
                    int height = yTile == yTileCount ? yRemainder : 16;
                    int x = xTile * 16;
                    int y = yStart - (yTile + 1) * 16;
                    if (width <= 0 || height <= 0) continue;
                    int maskTop = 16 - height;
                    int maskRight = 16 - width;
                    TankElement.drawFluidTexture(x, y, fluidStillSprite, maskTop, maskRight, 100.0);
                }
            }
        }
        if (this.overlay != null) {
            RenderSystem.disableDepthTest();
            this.overlay.draw(transform, 0, 0);
            RenderSystem.enableDepthTest();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableAlphaTest();
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)1.0f);
    }

    private static void drawFluidTexture(double xCoord, double yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, double zLevel) {
        float uMin = textureSprite.func_94209_e();
        float uMax = textureSprite.func_94212_f();
        float vMin = textureSprite.func_94206_g();
        float vMax = textureSprite.func_94210_h();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_(xCoord, yCoord + 16.0, zLevel).func_225583_a_(uMin, vMax).func_181675_d();
        buffer.func_225582_a_(xCoord + 16.0 - (double)maskRight, yCoord + 16.0, zLevel).func_225583_a_(uMax, vMax).func_181675_d();
        buffer.func_225582_a_(xCoord + 16.0 - (double)maskRight, yCoord + (double)maskTop, zLevel).func_225583_a_(uMax, vMin).func_181675_d();
        buffer.func_225582_a_(xCoord, yCoord + (double)maskTop, zLevel).func_225583_a_(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }
}

