/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.layouts.ContainerElement;
import java.awt.Rectangle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;

@OnlyIn(value=Dist.CLIENT)
public abstract class Window
extends ContainerElement {
    @Nullable
    protected Minecraft mc = null;
    protected int mouseX = -1;
    protected int mouseY = -1;
    @Nullable
    protected GuiElement mousedOver;
    @Nullable
    protected GuiElement dragged;
    @Nullable
    protected GuiElement focused;
    protected Collection<GuiElement> hoverElements = Collections.emptyList();

    public Window(int width, int height) {
        this.setAssignedBounds(new Rectangle(0, 0, width, height));
    }

    public void onRemove(GuiElement element) {
        if (this.isMouseOver(element)) {
            this.setMousedOver(null);
        }
        if (this.isDragged(element)) {
            this.setDragged(null);
        }
        if (this.isFocused(element)) {
            this.setFocused(null);
        }
    }

    @Override
    public Window getWindow() {
        return this;
    }

    @Override
    public GuiElement setParent(@Nullable GuiElement parent) {
        return this;
    }

    public void init(int guiLeft, int guiTop) {
        this.setAssignedBounds(new Rectangle(guiLeft, guiTop, this.bounds.width, this.bounds.height));
    }

    @Nullable
    public GuiElement getDragged() {
        return this.dragged;
    }

    public void setDragged(@Nullable GuiElement widget) {
        this.setDraggedElement(widget, -1);
    }

    public void setDraggedElement(@Nullable GuiElement widget, int button) {
        if (this.dragged == widget) {
            return;
        }
        if (this.dragged != null) {
            this.dragged.onDragEnd(this.mouseX, this.mouseY);
        }
        this.dragged = widget;
        if (this.dragged != null) {
            this.dragged.onDragStart(this.mouseX, this.mouseY);
        }
    }

    @Nullable
    public GuiElement getMousedOver() {
        return this.mousedOver;
    }

    public void setMousedOver(@Nullable GuiElement widget) {
        if (this.mousedOver == widget) {
            return;
        }
        if (this.mousedOver != null) {
            this.mousedOver.onMouseEnter(this.mouseX, this.mouseY);
        }
        this.mousedOver = widget;
        if (this.mousedOver != null) {
            this.mousedOver.onMouseLeave(this.mouseX, this.mouseY);
        }
    }

    @Nullable
    public GuiElement getFocused() {
        return this.focused;
    }

    public void setFocused(@Nullable GuiElement widget) {
        if (this.focused == widget) {
            return;
        }
        if (widget != null && !widget.canFocus()) {
            widget = null;
        }
        if (this.focused != null) {
            // empty if block
        }
        this.focused = widget;
        if (this.focused != null) {
            // empty if block
        }
    }

    public boolean isMouseOver(GuiElement element) {
        return this.getMousedOver() == element;
    }

    public boolean isDragged(GuiElement element) {
        return this.getDragged() == element;
    }

    public boolean isFocused(GuiElement element) {
        return this.getFocused() == element;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateClient() {
        if (!this.isVisible()) {
            return;
        }
        this.updateWindow();
        this.onUpdateClient();
        for (GuiElement widget : this.getElements()) {
            widget.updateClient();
        }
    }

    protected void updateWindow() {
        this.hoverElements = this.calculateHovered();
        this.setMousedOver(this.calculateMousedOver());
        if (!(this.getFocused() == null || this.getFocused().isVisible() && this.getFocused().isEnabled())) {
            this.setFocused(null);
        }
        if (!Minecraft.func_71410_x().field_71417_B.func_198030_b() && this.dragged != null) {
            this.setDragged(null);
        }
    }

    @Nullable
    private GuiElement calculateMousedOver() {
        for (GuiElement element : this.hoverElements) {
            if (!element.isEnabled() || !element.isVisible() || !element.canMouseOver()) continue;
            return element;
        }
        return null;
    }

    private Deque<GuiElement> calculateHovered() {
        ArrayDeque<GuiElement> list = new ArrayDeque<GuiElement>();
        for (GuiElement element : this.getQueuedElements(this)) {
            if (!element.isMouseOver()) continue;
            list.addLast(element);
        }
        return list;
    }

    private Collection<GuiElement> getQueuedElements(GuiElement element) {
        ArrayList<GuiElement> widgets = new ArrayList<GuiElement>();
        if (element instanceof ContainerElement) {
            ContainerElement group = (ContainerElement)element;
            boolean addChildren = true;
            if (element.isCropped()) {
                int mouseX = this.getRelativeMouseX(element);
                int mouseY = this.getRelativeMouseY(element);
                GuiElement cropRelative = element.getCropElement() != null ? element.getCropElement() : this;
                int posX = cropRelative.getAbsoluteX() - element.getAbsoluteX();
                int posY = cropRelative.getAbsoluteY() - element.getAbsoluteY();
                boolean bl = addChildren = mouseX >= posX && mouseY >= posY && mouseX <= posX + element.getCropWidth() && mouseY <= posY + element.getCropHeight();
            }
            if (addChildren) {
                ListIterator<GuiElement> iterator = group.getElements().listIterator(group.getElements().size());
                while (iterator.hasPrevious()) {
                    GuiElement child = iterator.previous();
                    widgets.addAll(this.getQueuedElements(child));
                }
            }
        }
        widgets.add(element);
        return widgets;
    }

    public void drawTooltip(MatrixStack transform, int mouseX, int mouseY) {
        ToolTip lines = this.getTooltip(mouseX, mouseY);
        if (!lines.isEmpty()) {
            RenderSystem.pushMatrix();
            MainWindow window = Minecraft.func_71410_x().func_228018_at_();
            GuiUtils.drawHoveringText((MatrixStack)transform, lines.getLines(), (int)(mouseX - this.getX()), (int)(mouseY - this.getY()), (int)window.func_198107_o(), (int)window.func_198087_p(), (int)-1, (FontRenderer)this.getFontRenderer());
            RenderSystem.popMatrix();
        }
    }

    @Override
    public ToolTip getTooltip(int mouseX, int mouseY) {
        ToolTip toolTip = new ToolTip();
        for (GuiElement element : this.hoverElements) {
            if (!element.isEnabled() || !element.isVisible() || !element.hasTooltip()) continue;
            toolTip.addAll(element.getTooltip(this.getRelativeMouseX(element), this.getRelativeMouseY(element)));
        }
        return toolTip;
    }

    public void setMousePosition(int mouseX, int mouseY) {
        float dx = (float)mouseX - (float)this.mouseX;
        float dy = (float)mouseY - (float)this.mouseY;
        if (dx != 0.0f || dy != 0.0f) {
            if (this.dragged != null) {
                this.onMouseDrag(mouseX, mouseY);
            } else {
                this.onMouseMove(mouseX, mouseY);
            }
        }
        if (mouseX != this.mouseX || mouseY != this.mouseY) {
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.setMousedOver(this.calculateMousedOver());
        }
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public int getRelativeMouseX(@Nullable GuiElement element) {
        if (element == null) {
            return this.mouseX;
        }
        return this.mouseX - element.getAbsoluteX();
    }

    public int getRelativeMouseY(@Nullable GuiElement element) {
        if (element == null) {
            return this.mouseY;
        }
        return this.mouseY - element.getAbsoluteY();
    }

    @Override
    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        return this.focused != null && this.focused.onKeyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean onKeyReleased(int keyCode, int scanCode, int modifiers) {
        return this.focused != null && this.focused.onKeyReleased(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean onCharTyped(char keyCode, int modifiers) {
        return this.focused != null && this.focused.onCharTyped(keyCode, modifiers);
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.setDraggedElement(this.mousedOver, mouseButton);
        this.setFocused(this.mousedOver);
        return super.onMouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean onMouseReleased(double mouseX, double mouseY, int mouseButton) {
        this.setDragged(null);
        return super.onMouseReleased(mouseX, mouseY, mouseButton);
    }

    public abstract int getScreenWidth();

    public abstract int getScreenHeight();

    public abstract int getGuiLeft();

    public abstract int getGuiTop();

    public abstract Screen getGui();

    public abstract int getGuiHeight();

    public abstract int getGuiWidth();

    protected Minecraft getMinecraft() {
        if (this.mc == null) {
            this.mc = Minecraft.func_71410_x();
        }
        return this.mc;
    }

    public TextureManager getTextureManager() {
        return this.getMinecraft().func_110434_K();
    }

    public FontRenderer getFontRenderer() {
        return this.getMinecraft().field_71466_p;
    }
}

