/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.core.IToolPipette;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.fluids.StandardTank;
import forestry.core.gui.IContainerLiquidTanks;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.utils.ResourceUtil;
import forestry.farming.gui.ContainerFarm;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

@OnlyIn(value=Dist.CLIENT)
public class TankWidget
extends Widget {
    private int overlayTexX = 176;
    private int overlayTexY = 0;
    private int slot = 0;
    protected boolean drawOverlay = true;

    public TankWidget(WidgetManager manager, int xPos, int yPos, int slot) {
        super(manager, xPos, yPos);
        this.slot = slot;
        this.height = 58;
    }

    public TankWidget setOverlayOrigin(int x, int y) {
        this.overlayTexX = x;
        this.overlayTexY = y;
        return this;
    }

    @Nullable
    public IFluidTank getTank() {
        Container container = this.manager.gui.func_212873_a_();
        if (container instanceof IContainerLiquidTanks) {
            return ((IContainerLiquidTanks)container).getTank(this.slot);
        }
        if (container instanceof ContainerFarm) {
            return ((ContainerFarm)container).getTank(this.slot);
        }
        return null;
    }

    @Override
    public void draw(MatrixStack transform, int startY, int startX) {
        Fluid fluid;
        RenderSystem.disableBlend();
        IFluidTank tank = this.getTank();
        if (tank == null || tank.getCapacity() <= 0) {
            return;
        }
        FluidStack contents = tank.getFluid();
        Minecraft minecraft = Minecraft.func_71410_x();
        TextureManager textureManager = minecraft.func_110434_K();
        if (!contents.isEmpty() && contents.getAmount() > 0 && contents.getFluid() != null && (fluid = contents.getFluid()) != null) {
            ResourceLocation fluidStill = fluid.getAttributes().getStillTexture(contents);
            TextureAtlasSprite fluidStillSprite = null;
            if (fluidStill != null) {
                fluidStillSprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidStill);
            }
            if (fluidStillSprite == null) {
                fluidStillSprite = ResourceUtil.getMissingTexture();
            }
            int fluidColor = fluid.getAttributes().getColor(contents);
            int scaledAmount = contents.getAmount() * this.height / tank.getCapacity();
            if (contents.getAmount() > 0 && scaledAmount < 1) {
                scaledAmount = 1;
            }
            if (scaledAmount > this.height) {
                scaledAmount = this.height;
            }
            textureManager.func_110577_a(AtlasTexture.field_110575_b);
            TankWidget.setGLColorFromInt(fluidColor);
            int xTileCount = this.width / 16;
            int xRemainder = this.width - xTileCount * 16;
            int yTileCount = scaledAmount / 16;
            int yRemainder = scaledAmount - yTileCount * 16;
            int yStart = startY + this.height;
            for (int xTile = 0; xTile <= xTileCount; ++xTile) {
                for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                    int width = xTile == xTileCount ? xRemainder : 16;
                    int height = yTile == yTileCount ? yRemainder : 16;
                    int x = startX + xTile * 16;
                    int y = yStart - (yTile + 1) * 16;
                    if (width <= 0 || height <= 0) continue;
                    int maskTop = 16 - height;
                    int maskRight = 16 - width;
                    TankWidget.drawFluidTexture(x + this.xPos, y + this.yPos, fluidStillSprite, maskTop, maskRight, 100.0);
                }
            }
        }
        if (this.drawOverlay) {
            RenderSystem.enableAlphaTest();
            RenderSystem.disableDepthTest();
            textureManager.func_110577_a(this.manager.gui.textureFile);
            this.manager.gui.func_238474_b_(transform, startX + this.xPos, startY + this.yPos, this.overlayTexX, this.overlayTexY, 16, 60);
            RenderSystem.enableDepthTest();
            RenderSystem.disableAlphaTest();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        IFluidTank tank = this.getTank();
        if (!(tank instanceof StandardTank)) {
            return null;
        }
        StandardTank standardTank = (StandardTank)tank;
        return standardTank.getToolTip();
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)1.0f);
    }

    private static void drawFluidTexture(double xCoord, double yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, double zLevel) {
        float uMin = textureSprite.func_94209_e();
        float uMax = textureSprite.func_94212_f();
        float vMin = textureSprite.func_94206_g();
        float vMax = textureSprite.func_94210_h();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_(xCoord, yCoord + 16.0, zLevel).func_225583_a_(uMin, vMax).func_181675_d();
        buffer.func_225582_a_(xCoord + 16.0 - (double)maskRight, yCoord + 16.0, zLevel).func_225583_a_(uMax, vMax).func_181675_d();
        buffer.func_225582_a_(xCoord + 16.0 - (double)maskRight, yCoord + (double)maskTop, zLevel).func_225583_a_(uMax, vMin).func_181675_d();
        buffer.func_225582_a_(xCoord, yCoord + (double)maskTop, zLevel).func_225583_a_(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        ClientPlayerEntity player = this.manager.minecraft.field_71439_g;
        ItemStack itemstack = player.field_71071_by.func_70445_o();
        if (itemstack.func_190926_b()) {
            return;
        }
        Item held = itemstack.func_77973_b();
        Container container = this.manager.gui.func_212873_a_();
        if (held instanceof IToolPipette && container instanceof IContainerLiquidTanks) {
            ((IContainerLiquidTanks)container).handlePipetteClickClient(this.slot, (PlayerEntity)player);
        }
    }
}

