/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import com.google.common.base.Preconditions;
import forestry.core.tiles.IFilterSlotDelegate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class ItemInventory
implements IInventory,
IFilterSlotDelegate,
ICapabilityProvider {
    private static final String KEY_SLOTS = "Slots";
    private static final String KEY_UID = "UID";
    private static final Random rand = new Random();
    private final IItemHandler itemHandler = new InvWrapper((IInventory)this);
    protected final PlayerEntity player;
    private ItemStack parent;
    private final NonNullList<ItemStack> inventoryStacks;

    public ItemInventory(PlayerEntity player, int size, ItemStack parent) {
        Preconditions.checkArgument((!parent.func_190926_b() ? 1 : 0) != 0, (Object)"Parent cannot be empty.");
        this.player = player;
        this.parent = parent;
        this.inventoryStacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        CompoundNBT nbt = parent.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
            parent.func_77982_d(nbt);
        }
        this.setUID(nbt);
        CompoundNBT nbtSlots = nbt.func_74775_l(KEY_SLOTS);
        for (int i = 0; i < this.inventoryStacks.size(); ++i) {
            String slotKey = ItemInventory.getSlotNBTKey(i);
            if (nbtSlots.func_74764_b(slotKey)) {
                CompoundNBT itemNbt = nbtSlots.func_74775_l(slotKey);
                ItemStack itemStack = ItemStack.func_199557_a((CompoundNBT)itemNbt);
                this.inventoryStacks.set(i, (Object)itemStack);
                continue;
            }
            this.inventoryStacks.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public static int getOccupiedSlotCount(ItemStack itemStack) {
        CompoundNBT nbt = itemStack.func_77978_p();
        if (nbt == null) {
            return 0;
        }
        CompoundNBT slotNbt = nbt.func_74775_l(KEY_SLOTS);
        return slotNbt.func_186856_d();
    }

    private void setUID(CompoundNBT nbt) {
        if (!nbt.func_74764_b(KEY_UID)) {
            nbt.func_74768_a(KEY_UID, rand.nextInt());
        }
    }

    public boolean isParentItemInventory(ItemStack itemStack) {
        ItemStack parent = this.getParent();
        return ItemInventory.isSameItemInventory(parent, itemStack);
    }

    protected ItemStack getParent() {
        for (Hand hand : Hand.values()) {
            ItemStack held = this.player.func_184586_b(hand);
            if (!ItemInventory.isSameItemInventory(held, this.parent)) continue;
            return held;
        }
        return this.parent;
    }

    protected void setParent(ItemStack parent) {
        this.parent = parent;
    }

    @Nullable
    protected Hand getHand() {
        for (Hand hand : Hand.values()) {
            ItemStack held = this.player.func_184586_b(hand);
            if (!ItemInventory.isSameItemInventory(held, this.parent)) continue;
            return hand;
        }
        return null;
    }

    private static boolean isSameItemInventory(ItemStack base, ItemStack comparison) {
        int comparisonUID;
        if (base.func_190926_b() || comparison.func_190926_b()) {
            return false;
        }
        if (base.func_77973_b() != comparison.func_77973_b()) {
            return false;
        }
        CompoundNBT baseTagCompound = base.func_77978_p();
        CompoundNBT comparisonTagCompound = comparison.func_77978_p();
        if (baseTagCompound == null || comparisonTagCompound == null) {
            return false;
        }
        if (!baseTagCompound.func_74764_b(KEY_UID) || !comparisonTagCompound.func_74764_b(KEY_UID)) {
            return false;
        }
        int baseUID = baseTagCompound.func_74762_e(KEY_UID);
        return baseUID == (comparisonUID = comparisonTagCompound.func_74762_e(KEY_UID));
    }

    private void writeToParentNBT() {
        ItemStack parent = this.getParent();
        CompoundNBT nbt = parent.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
            parent.func_77982_d(nbt);
        }
        CompoundNBT slotsNbt = new CompoundNBT();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            String slotKey = ItemInventory.getSlotNBTKey(i);
            CompoundNBT itemNbt = new CompoundNBT();
            itemStack.func_77955_b(itemNbt);
            slotsNbt.func_218657_a(slotKey, (INBT)itemNbt);
        }
        nbt.func_218657_a(KEY_SLOTS, (INBT)slotsNbt);
        this.onWriteNBT(nbt);
    }

    private static String getSlotNBTKey(int i) {
        return Integer.toString(i, 36);
    }

    protected void onWriteNBT(CompoundNBT nbt) {
    }

    public void onSlotClick(int slotIndex, PlayerEntity player) {
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventoryStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventoryStacks, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public void func_70299_a(int index, ItemStack itemstack) {
        CompoundNBT slotNbt;
        this.inventoryStacks.set(index, (Object)itemstack);
        ItemStack parent = this.getParent();
        CompoundNBT nbt = parent.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
            parent.func_77982_d(nbt);
        }
        if (!nbt.func_74764_b(KEY_SLOTS)) {
            slotNbt = new CompoundNBT();
            nbt.func_218657_a(KEY_SLOTS, (INBT)slotNbt);
        } else {
            slotNbt = nbt.func_74775_l(KEY_SLOTS);
        }
        String slotKey = ItemInventory.getSlotNBTKey(index);
        if (itemstack.func_190926_b()) {
            slotNbt.func_82580_o(slotKey);
        } else {
            CompoundNBT itemNbt = new CompoundNBT();
            itemstack.func_77955_b(itemNbt);
            slotNbt.func_218657_a(slotKey, (INBT)itemNbt);
        }
    }

    public ItemStack func_70301_a(int i) {
        return (ItemStack)this.inventoryStacks.get(i);
    }

    public int func_70302_i_() {
        return this.inventoryStacks.size();
    }

    public int func_70297_j_() {
        return 64;
    }

    public final void func_70296_d() {
        this.writeToParentNBT();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return this.canSlotAccept(slotIndex, itemStack);
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack toReturn = this.func_70301_a(slot);
        if (!toReturn.func_190926_b()) {
            this.func_70299_a(slot, ItemStack.field_190927_a);
        }
        return toReturn;
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.itemHandler).cast();
        }
        return LazyOptional.empty();
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public void func_174888_l() {
        this.inventoryStacks.clear();
    }
}

