/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.api.core.ItemGroups;
import forestry.core.config.Config;
import forestry.core.fluids.ForestryFluids;
import forestry.core.items.ItemForestry;
import forestry.core.items.definitions.DrinkProperties;
import forestry.core.items.definitions.EnumContainerType;
import forestry.core.items.definitions.FluidHandlerItemForestry;
import forestry.core.utils.Translator;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.FoodStats;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemFluidContainerForestry
extends ItemForestry {
    private final EnumContainerType type;

    public ItemFluidContainerForestry(EnumContainerType type) {
        super(new Item.Properties().func_200916_a(ItemGroups.tabStorage));
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((IItemProvider)this));
            for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
                ItemStack itemStack;
                FluidHandlerItemForestry fluidHandler;
                if (fluid instanceof FlowingFluid && ((FlowingFluid)fluid).func_210198_f() != fluid || (fluidHandler = new FluidHandlerItemForestry(itemStack = new ItemStack((IItemProvider)this), this.type)).fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE) != 1000) continue;
                ItemStack filled = fluidHandler.getContainer();
                subItems.add((Object)filled);
            }
        }
    }

    public EnumContainerType getType() {
        return this.type;
    }

    protected FluidStack getContained(ItemStack itemStack) {
        if (itemStack.func_190916_E() != 1) {
            itemStack = itemStack.func_77946_l();
            itemStack.func_190920_e(1);
        }
        FluidHandlerItemForestry fluidHandler = new FluidHandlerItemForestry(itemStack, this.type);
        return fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemFluidContainerForestry) {
            FluidStack fluid = this.getContained(stack);
            if (!fluid.isEmpty()) {
                String exactTranslationKey = "item.forestry." + this.type.func_176610_l() + '.' + fluid.getFluid().getRegistryName();
                return Translator.tryTranslate(exactTranslationKey, () -> {
                    String grammarKey = "item.forestry." + this.type.func_176610_l() + ".grammar";
                    return new TranslationTextComponent(grammarKey, new Object[]{fluid.getDisplayName()});
                });
            }
            String unlocalizedname = "item.forestry." + this.type.func_176610_l() + ".empty";
            return new TranslationTextComponent(unlocalizedname);
        }
        return super.func_200295_i(stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        DrinkProperties drinkProperties = this.getDrinkProperties(stack);
        if (drinkProperties != null && entityLiving instanceof PlayerEntity && !((PlayerEntity)entityLiving).func_184812_l_()) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (!worldIn.field_72995_K) {
                FoodStats foodStats = player.func_71024_bL();
                foodStats.func_75122_a(drinkProperties.getHealAmount(), drinkProperties.getSaturationModifier());
                worldIn.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        }
        return stack;
    }

    @Nullable
    protected DrinkProperties getDrinkProperties(ItemStack itemStack) {
        ForestryFluids definition;
        FluidStack contained = this.getContained(itemStack);
        if (!contained.isEmpty() && (definition = ForestryFluids.getFluidDefinition(contained)) != null) {
            return definition.getDrinkProperties();
        }
        return null;
    }

    public int func_77626_a(ItemStack itemstack) {
        DrinkProperties drinkProperties = this.getDrinkProperties(itemstack);
        if (drinkProperties != null) {
            return drinkProperties.getMaxItemUseDuration();
        }
        return super.func_77626_a(itemstack);
    }

    public UseAction func_77661_b(ItemStack itemstack) {
        DrinkProperties drinkProperties = this.getDrinkProperties(itemstack);
        if (drinkProperties != null) {
            return UseAction.DRINK;
        }
        return UseAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand handIn) {
        ItemStack heldItem = player.func_184586_b(handIn);
        DrinkProperties drinkProperties = this.getDrinkProperties(heldItem);
        if (drinkProperties != null) {
            if (player.func_71043_e(false)) {
                player.func_184598_c(handIn);
                return new ActionResult(ActionResultType.SUCCESS, (Object)heldItem);
            }
            return new ActionResult(ActionResultType.FAIL, (Object)heldItem);
        }
        if (Config.CapsuleFluidPickup) {
            BlockRayTraceResult target = ItemFluidContainerForestry.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
            if (target.func_216346_c() != RayTraceResult.Type.BLOCK) {
                return ActionResult.func_226250_c_((Object)heldItem);
            }
            ItemStack singleBucket = heldItem.func_77946_l();
            singleBucket.func_190920_e(1);
            FluidActionResult filledResult = FluidUtil.tryPickUpFluid((ItemStack)singleBucket, (PlayerEntity)player, (World)world, (BlockPos)target.func_216350_a(), (Direction)target.func_216354_b());
            if (filledResult.isSuccess()) {
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)filledResult.result);
                if (!player.func_184812_l_()) {
                    heldItem.func_190918_g(1);
                }
                return ActionResult.func_226248_a_((Object)heldItem);
            }
        }
        return super.func_77659_a(world, player, handIn);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidHandlerItemForestry(stack, this.type);
    }
}

