/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items.definitions;

import forestry.core.config.Config;
import forestry.core.items.definitions.EnumContainerType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;

public class FluidHandlerItemForestry
extends FluidHandlerItemStackSimple.Consumable {
    private final EnumContainerType containerType;

    public FluidHandlerItemForestry(ItemStack container, EnumContainerType containerType) {
        super(container, 1000);
        this.containerType = containerType;
    }

    private boolean contentsAllowed(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return false;
        }
        if (this.containerType == EnumContainerType.CAPSULE) {
            return (double)fluid.getAttributes().getTemperature(fluidStack) < 310.15;
        }
        return true;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return this.contentsAllowed(fluid);
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return this.contentsAllowed(fluid);
    }

    protected void setFluid(FluidStack fluid) {
        super.setFluid(fluid);
        this.container.func_196085_b(1);
    }

    protected void setContainerToEmpty() {
        if (Config.nonConsumableCapsules) {
            this.container.func_77978_p().func_82580_o("Fluid");
        } else {
            super.setContainerToEmpty();
        }
    }
}

