/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.mojang.authlib.GameProfile;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.ILocatable;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.MultiblockControllerBase;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.owner.OwnerHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.world.World;

public abstract class MultiblockControllerForestry
extends MultiblockControllerBase
implements ISidedInventory,
IOwnedTile,
IErrorLogicSource,
ILocatable {
    private final OwnerHandler ownerHandler = new OwnerHandler();
    private final IErrorLogic errorLogic = ForestryAPI.errorStateRegistry.createErrorLogic();

    protected MultiblockControllerForestry(World world) {
        super(world);
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return this.ownerHandler;
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return this.errorLogic;
    }

    @Override
    public World getWorldObj() {
        return this.world;
    }

    @Override
    protected void onMachineAssembled() {
        super.onMachineAssembled();
        if (this.world.field_72995_K) {
            return;
        }
        HashMultiset owners = HashMultiset.create();
        for (IMultiblockComponent part : this.connectedParts) {
            GameProfile owner = part.getOwner();
            if (owner == null) continue;
            owners.add((Object)owner);
        }
        GameProfile owner = null;
        int max = 0;
        for (Multiset.Entry entry : owners.entrySet()) {
            int count = entry.getCount();
            if (count <= max) continue;
            max = count;
            owner = (GameProfile)entry.getElement();
        }
        if (owner != null) {
            this.getOwnerHandler().setOwner(owner);
        }
    }

    @Override
    public CompoundNBT write(CompoundNBT data) {
        this.ownerHandler.write(data);
        return data;
    }

    @Override
    public void read(CompoundNBT data) {
        this.ownerHandler.read(data);
    }

    public IInventoryAdapter getInternalInventory() {
        return FakeInventoryAdapter.instance();
    }

    public void func_70296_d() {
        this.getInternalInventory().func_70296_d();
    }

    public final int func_70302_i_() {
        return this.getInternalInventory().func_70302_i_();
    }

    public final ItemStack func_70301_a(int slotIndex) {
        return this.getInternalInventory().func_70301_a(slotIndex);
    }

    public final ItemStack func_70298_a(int slotIndex, int amount) {
        return this.getInternalInventory().func_70298_a(slotIndex, amount);
    }

    public ItemStack func_70304_b(int slotIndex) {
        return this.getInternalInventory().func_70304_b(slotIndex);
    }

    public final void func_70299_a(int slotIndex, ItemStack itemstack) {
        this.getInternalInventory().func_70299_a(slotIndex, itemstack);
    }

    public final int func_70297_j_() {
        return this.getInternalInventory().func_70297_j_();
    }

    public final void func_174889_b(PlayerEntity player) {
        this.getInternalInventory().func_174889_b(player);
    }

    public final void func_174886_c(PlayerEntity player) {
        this.getInternalInventory().func_174886_c(player);
    }

    public final boolean func_70300_a(PlayerEntity player) {
        return this.getInternalInventory().func_70300_a(player);
    }

    public final boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().func_94041_b(slotIndex, itemStack);
    }

    public int[] func_180463_a(Direction side) {
        return this.getInternalInventory().func_180463_a(side);
    }

    public final boolean func_180462_a(int slotIndex, ItemStack itemStack, Direction side) {
        return this.getInternalInventory().func_180462_a(slotIndex, itemStack, side);
    }

    public final boolean func_180461_b(int slotIndex, ItemStack itemStack, Direction side) {
        return this.getInternalInventory().func_180461_b(slotIndex, itemStack, side);
    }

    public void func_174888_l() {
        this.getInternalInventory().func_174888_l();
    }
}

