/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import com.mojang.authlib.GameProfile;
import forestry.api.core.ILocatable;
import forestry.api.multiblock.IMultiblockLogic;
import forestry.api.multiblock.MultiblockTileEntityBase;
import forestry.core.config.Constants;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.IFilterSlotDelegate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class MultiblockTileEntityForestry<T extends IMultiblockLogic>
extends MultiblockTileEntityBase<T>
implements ISidedInventory,
IFilterSlotDelegate,
ILocatable,
INamedContainerProvider {
    @Nullable
    private GameProfile owner;

    public MultiblockTileEntityForestry(TileEntityType<?> tileEntityType, T multiblockLogic) {
        super(tileEntityType, multiblockLogic);
    }

    public void openGui(ServerPlayerEntity player, BlockPos pos) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)this, (BlockPos)pos);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT data) {
        super.func_230337_a_(state, data);
        if (data.func_74764_b("owner")) {
            CompoundNBT ownerNbt = data.func_74775_l("owner");
            this.owner = NBTUtil.func_152459_a((CompoundNBT)ownerNbt);
        }
        this.getInternalInventory().read(data);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT data) {
        data = super.func_189515_b(data);
        if (this.owner != null) {
            CompoundNBT nbt = new CompoundNBT();
            NBTUtil.func_180708_a((CompoundNBT)nbt, (GameProfile)this.owner);
            data.func_218657_a("owner", (INBT)nbt);
        }
        this.getInternalInventory().write(data);
        return data;
    }

    public IInventoryAdapter getInternalInventory() {
        return FakeInventoryAdapter.instance();
    }

    public boolean allowsAutomation() {
        return false;
    }

    public boolean func_191420_l() {
        return this.getInternalInventory().func_191420_l();
    }

    public final int func_70302_i_() {
        return this.getInternalInventory().func_70302_i_();
    }

    public final ItemStack func_70301_a(int slotIndex) {
        return this.getInternalInventory().func_70301_a(slotIndex);
    }

    public final ItemStack func_70298_a(int slotIndex, int amount) {
        return this.getInternalInventory().func_70298_a(slotIndex, amount);
    }

    public ItemStack func_70304_b(int slotIndex) {
        return this.getInternalInventory().func_70304_b(slotIndex);
    }

    public final void func_70299_a(int slotIndex, ItemStack itemstack) {
        this.getInternalInventory().func_70299_a(slotIndex, itemstack);
    }

    public final int func_70297_j_() {
        return this.getInternalInventory().func_70297_j_();
    }

    public final void func_174889_b(PlayerEntity player) {
        this.getInternalInventory().func_174889_b(player);
    }

    public final void func_174886_c(PlayerEntity player) {
        this.getInternalInventory().func_174886_c(player);
    }

    public final boolean func_70300_a(PlayerEntity player) {
        return this.getInternalInventory().func_70300_a(player);
    }

    public final boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().func_94041_b(slotIndex, itemStack);
    }

    public int[] func_180463_a(Direction side) {
        if (this.allowsAutomation()) {
            return this.getInternalInventory().func_180463_a(side);
        }
        return Constants.SLOTS_NONE;
    }

    public final boolean func_180462_a(int slotIndex, ItemStack itemStack, Direction side) {
        return this.allowsAutomation() && this.getInternalInventory().func_180462_a(slotIndex, itemStack, side);
    }

    public final boolean func_180461_b(int slotIndex, ItemStack itemStack, Direction side) {
        return this.allowsAutomation() && this.getInternalInventory().func_180461_b(slotIndex, itemStack, side);
    }

    @Override
    public final boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public final boolean isLocked(int slotIndex) {
        return this.getInternalInventory().isLocked(slotIndex);
    }

    @Override
    public final World getWorldObj() {
        return this.field_145850_b;
    }

    @Override
    @Nullable
    public final GameProfile getOwner() {
        return this.owner;
    }

    public final void setOwner(GameProfile owner) {
        this.owner = owner;
    }

    public void func_174888_l() {
        this.getInternalInventory().func_174888_l();
    }
}

