/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.api.core.ILocatable;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.TileUtil;
import java.io.IOException;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PacketGuiUpdate
extends ForestryPacket
implements IForestryPacketClient {
    private final BlockPos pos;
    private final IStreamableGui guiDataTile;

    public <T extends IStreamableGui & ILocatable> PacketGuiUpdate(T guiDataTile) {
        this.pos = ((ILocatable)guiDataTile).getCoordinates();
        this.guiDataTile = guiDataTile;
    }

    @Override
    protected void writeData(PacketBufferForestry data) {
        data.func_179255_a(this.pos);
        this.guiDataTile.writeGuiData(data);
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.GUI_UPDATE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, PlayerEntity player) throws IOException {
            BlockPos pos = data.func_179259_c();
            IStreamableGui tile = TileUtil.getTile((IBlockReader)player.field_70170_p, pos, IStreamableGui.class);
            if (tile != null) {
                tile.readGuiData(data);
            }
        }
    }
}

