/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import forestry.core.particles.CoreParticles;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.vector.Vector3d;

public class SnowParticleData
implements IParticleData {
    public static final IParticleData.IDeserializer<SnowParticleData> DESERIALIZER = new IParticleData.IDeserializer<SnowParticleData>(){

        @Nonnull
        public SnowParticleData fromCommand(@Nonnull ParticleType<SnowParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            double particleStartX = reader.readDouble();
            reader.expect(' ');
            double particleStartY = reader.readDouble();
            reader.expect(' ');
            double particleStartZ = reader.readDouble();
            reader.expect(' ');
            return new SnowParticleData(particleStartX, particleStartY, particleStartZ);
        }

        public SnowParticleData fromNetwork(@Nonnull ParticleType<SnowParticleData> type, PacketBuffer buf) {
            return new SnowParticleData(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }
    };
    public static final Codec<SnowParticleData> CODEC = RecordCodecBuilder.create(val -> val.group((App)Codec.DOUBLE.fieldOf("particleStart").forGetter(data -> data.particleStart.func_82615_a()), (App)Codec.DOUBLE.fieldOf("particleStart").forGetter(data -> data.particleStart.func_82617_b()), (App)Codec.DOUBLE.fieldOf("particleStart").forGetter(data -> data.particleStart.func_82617_b())).apply((Applicative)val, SnowParticleData::new));
    public final Vector3d particleStart;

    public SnowParticleData(double particleStartX, double particleStartY, double particleStartZ) {
        this.particleStart = new Vector3d(particleStartX, particleStartY, particleStartZ);
    }

    @Nonnull
    public ParticleType<?> func_197554_b() {
        return CoreParticles.SNOW_PARTICLE.getParticleType();
    }

    public void func_197553_a(@Nonnull PacketBuffer buffer) {
        buffer.writeDouble(this.particleStart.func_82615_a());
        buffer.writeDouble(this.particleStart.func_82617_b());
        buffer.writeDouble(this.particleStart.func_82616_c());
    }

    @Nonnull
    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %2f %2f %2f", this.func_197554_b().getRegistryName(), this.particleStart.func_82615_a(), this.particleStart.func_82617_b(), this.particleStart.func_82616_c());
    }
}

