/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.blocks.BlockBase;
import forestry.core.render.ForestryResource;
import forestry.core.render.IForestryRenderer;
import forestry.core.render.RenderHelper;
import forestry.core.tiles.TileAnalyzer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class RenderAnalyzer
implements IForestryRenderer<TileAnalyzer> {
    private final ModelRenderer pedestal;
    private final ModelRenderer cover;
    private final ModelRenderer tower1;
    private final ModelRenderer tower2;
    private final ResourceLocation[] textures;

    public RenderAnalyzer() {
        int textureWidth = 64;
        int textureHeight = 32;
        this.textures = new ResourceLocation[]{new ForestryResource("textures/block/analyzer_pedestal.png"), new ForestryResource("textures/block/analyzer_tower1.png"), new ForestryResource("textures/block/analyzer_tower2.png")};
        this.pedestal = new ModelRenderer(textureWidth, textureHeight, 0, 0);
        this.pedestal.func_228300_a_(-8.0f, -8.0f, -8.0f, 16.0f, 1.0f, 16.0f);
        this.pedestal.func_78793_a(8.0f, 8.0f, 8.0f);
        this.cover = new ModelRenderer(textureWidth, textureHeight, 0, 0);
        this.cover.func_228300_a_(-8.0f, -8.0f, -8.0f, 16.0f, 1.0f, 16.0f);
        this.cover.func_78793_a(8.0f, 8.0f, 8.0f);
        this.tower1 = new ModelRenderer(textureWidth, textureHeight, 0, 0);
        this.tower1.func_228300_a_(-8.0f, -7.0f, -7.0f, 2.0f, 14.0f, 14.0f);
        this.tower1.func_78793_a(8.0f, 8.0f, 8.0f);
        this.tower2 = new ModelRenderer(textureWidth, textureHeight, 0, 0);
        this.tower2.func_228300_a_(6.0f, -7.0f, -7.0f, 2.0f, 14.0f, 14.0f);
        this.tower2.func_78793_a(8.0f, 8.0f, 8.0f);
    }

    @Override
    public void renderTile(TileAnalyzer tile, RenderHelper helper) {
        World worldObj = tile.getWorldObj();
        BlockState blockState = worldObj.func_180495_p(tile.func_174877_v());
        if (blockState.func_177230_c() instanceof BlockBase) {
            Direction facing = (Direction)blockState.func_177229_b(BlockBase.FACING);
            this.render(tile.getIndividualOnDisplay(), worldObj, facing, helper);
        }
    }

    @Override
    public void renderItem(ItemStack stack, RenderHelper helper) {
        this.render(ItemStack.field_190927_a, null, Direction.WEST, helper);
    }

    private void render(ItemStack itemstack, @Nullable World world, Direction orientation, RenderHelper helper) {
        Vector3f rotation = new Vector3f(0.0f, 0.0f, 0.0f);
        switch (orientation) {
            case EAST: {
                rotation.setY(1.5707964f);
                break;
            }
            case WEST: {
                rotation.setY(-1.5707964f);
                break;
            }
            case SOUTH: {
                break;
            }
            default: {
                rotation.setY((float)Math.PI);
            }
        }
        helper.setRotation(rotation);
        helper.push();
        helper.renderModel(this.textures[0], this.pedestal);
        helper.renderModel(this.textures[0], new Vector3f(0.0f, 0.0f, (float)Math.PI), this.cover);
        helper.renderModel(this.textures[1], this.tower1);
        helper.renderModel(this.textures[2], this.tower2);
        helper.pop();
        if (itemstack.func_190926_b() || world == null) {
            return;
        }
        float renderScale = 1.0f;
        helper.push();
        helper.translate(0.5, 0.2f, 0.5);
        helper.scale(renderScale, renderScale, renderScale);
        helper.renderItem(itemstack, world);
        helper.pop();
    }
}

