/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.render.ForestryResource;
import forestry.core.render.IForestryRenderer;
import forestry.core.render.RenderHelper;
import forestry.core.tiles.TileMill;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class RenderMill
implements IForestryRenderer<TileMill> {
    private final ResourceLocation[] textures;
    private final ModelRenderer pedestal;
    private final ModelRenderer column;
    private final ModelRenderer extension;
    private final ModelRenderer blade1;
    private final ModelRenderer blade2;

    public RenderMill(String baseTexture) {
        int textureWidth = 64;
        int textureHeight = 32;
        this.pedestal = new ModelRenderer(textureWidth, textureHeight, 0, 0);
        this.pedestal.func_228300_a_(-8.0f, -8.0f, -8.0f, 16.0f, 1.0f, 16.0f);
        this.pedestal.field_78800_c = 8.0f;
        this.pedestal.field_78797_d = 8.0f;
        this.pedestal.field_78798_e = 8.0f;
        this.column = new ModelRenderer(textureWidth, textureHeight, 0, 0);
        this.column.func_228300_a_(-2.0f, -7.0f, -2.0f, 4.0f, 15.0f, 4.0f);
        this.column.field_78800_c = 8.0f;
        this.column.field_78797_d = 8.0f;
        this.column.field_78798_e = 8.0f;
        this.extension = new ModelRenderer(textureWidth, textureHeight, 0, 0);
        this.extension.func_228300_a_(1.0f, 8.0f, 7.0f, 14.0f, 2.0f, 2.0f);
        this.extension.field_78800_c = 0.0f;
        this.extension.field_78797_d = 0.0f;
        this.extension.field_78798_e = 0.0f;
        this.blade1 = new ModelRenderer(textureWidth, textureHeight, 0, 0);
        this.blade1.func_228300_a_(-4.0f, -5.0f, -3.0f, 8.0f, 12.0f, 1.0f);
        this.blade1.field_78800_c = 8.0f;
        this.blade1.field_78797_d = 8.0f;
        this.blade1.field_78798_e = 8.0f;
        this.blade2 = new ModelRenderer(textureWidth, textureHeight, 0, 0);
        this.blade2.func_228300_a_(-4.0f, -5.0f, 2.0f, 8.0f, 12.0f, 1.0f);
        this.blade2.field_78800_c = 8.0f;
        this.blade2.field_78797_d = 8.0f;
        this.blade2.field_78798_e = 8.0f;
        this.textures = new ResourceLocation[12];
        this.textures[Textures.PEDESTAL.ordinal()] = new ForestryResource(baseTexture + "pedestal.png");
        this.textures[Textures.EXTENSION.ordinal()] = new ForestryResource(baseTexture + "extension.png");
        this.textures[Textures.BLADE_1.ordinal()] = new ForestryResource(baseTexture + "blade1.png");
        this.textures[Textures.BLADE_2.ordinal()] = new ForestryResource(baseTexture + "blade2.png");
        for (int i = 0; i < 8; ++i) {
            this.textures[Textures.CHARGE.ordinal() + i] = new ForestryResource(baseTexture + "column_" + i + ".png");
        }
    }

    public RenderMill(String baseTexture, byte charges) {
        this(baseTexture);
    }

    @Override
    public void renderTile(TileMill tile, RenderHelper helper) {
        this.render(tile.progress, tile.charge, Direction.WEST, helper);
    }

    @Override
    public void renderItem(ItemStack stack, RenderHelper helper) {
        this.render(0.0f, 0, Direction.WEST, helper);
    }

    private void render(float progress, int charge, Direction orientation, RenderHelper helper) {
        helper.push();
        float step = (double)progress > 0.5 ? 3.99f - (progress - 0.5f) * 2.0f * 3.99f : progress * 2.0f * 3.99f;
        Vector3f rotation = new Vector3f(0.0f, 0.0f, 0.0f);
        float[] translate = new float[]{0.0f, 0.0f, 0.0f};
        float tfactor = step / 16.0f;
        switch (orientation) {
            case EAST: {
                rotation.setZ((float)Math.PI);
                rotation.setY(-1.5707964f);
                translate[0] = 1.0f;
                break;
            }
            case WEST: {
                rotation.setY(1.5707964f);
                translate[0] = -1.0f;
                break;
            }
            case UP: {
                translate[1] = 1.0f;
                break;
            }
            case DOWN: {
                rotation.setY((float)Math.PI);
                translate[1] = -1.0f;
                break;
            }
            case SOUTH: {
                rotation.setX(1.5707964f);
                rotation.setY(1.5707964f);
                translate[2] = 1.0f;
                break;
            }
            default: {
                rotation.setX(-1.5707964f);
                rotation.setY(1.5707964f);
                translate[2] = -1.0f;
            }
        }
        helper.setRotation(rotation);
        helper.renderModel(this.textures[Textures.PEDESTAL.ordinal()], this.pedestal);
        helper.renderModel(this.textures[Textures.CHARGE.ordinal() + charge], this.column);
        Vector3f invertedRotation = rotation.func_229195_e_();
        invertedRotation.func_195898_a(-1.0f);
        helper.renderModel(this.textures[Textures.EXTENSION.ordinal() + charge], invertedRotation, this.extension);
        helper.translate(translate[0] * tfactor, translate[1] * tfactor, translate[2] * tfactor);
        helper.renderModel(this.textures[Textures.BLADE_1.ordinal() + charge], this.blade1);
        helper.translate(-translate[0] * tfactor, -translate[1] * tfactor, -translate[2] * tfactor);
        helper.translate(-translate[0] * tfactor, translate[1] * tfactor, -translate[2] * tfactor);
        helper.renderModel(this.textures[Textures.BLADE_2.ordinal() + charge], this.blade2);
        helper.pop();
    }

    private static enum Textures {
        PEDESTAL,
        EXTENSION,
        BLADE_1,
        BLADE_2,
        CHARGE;

    }
}

