/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.google.common.base.Joiner;
import forestry.api.modules.ForestryModule;
import forestry.api.modules.IForestryModule;
import forestry.modules.ModuleManager;
import java.util.ArrayList;
import java.util.Set;
import net.minecraftforge.fml.CrashReportExtender;
import net.minecraftforge.fml.common.ICrashCallable;

public class ForestryModEnvWarningCallable
implements ICrashCallable {
    private final String disabledModulesMessage;

    public static void register() {
        Set<IForestryModule> configDisabledModules = ModuleManager.configDisabledModules;
        if (!configDisabledModules.isEmpty()) {
            ArrayList<String> disabledModuleNames = new ArrayList<String>();
            for (IForestryModule module : configDisabledModules) {
                ForestryModule info = module.getClass().getAnnotation(ForestryModule.class);
                disabledModuleNames.add(info.name());
            }
            String disabledModulesMessage = "Modules have been disabled in the config: " + Joiner.on((String)", ").join(disabledModuleNames);
            ForestryModEnvWarningCallable callable = new ForestryModEnvWarningCallable(disabledModulesMessage);
            CrashReportExtender.registerCrashCallable((ICrashCallable)callable);
        }
    }

    private ForestryModEnvWarningCallable(String disabledModulesMessage) {
        this.disabledModulesMessage = disabledModulesMessage;
    }

    public String call() {
        return this.disabledModulesMessage;
    }

    public String getLabel() {
        return "forestry ";
    }
}

