/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.google.common.collect.ForwardingList;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.utils.Log;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class NBTUtilForestry {
    public static <T extends INBT> NBTList<T> getNBTList(CompoundNBT nbt, String tag, EnumNBTType type) {
        ListNBT nbtList = nbt.func_150295_c(tag, type.ordinal());
        return new NBTList(nbtList);
    }

    public static CompoundNBT writeStreamableToNbt(IStreamable streamable, CompoundNBT nbt) {
        PacketBufferForestry data = new PacketBufferForestry(Unpooled.buffer());
        streamable.writeData(data);
        byte[] bytes = new byte[data.readableBytes()];
        data.getBytes(0, bytes);
        nbt.func_74773_a("dataBytes", bytes);
        return nbt;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void readStreamableFromNbt(IStreamable streamable, CompoundNBT nbt) {
        if (nbt.func_74764_b("dataBytes")) {
            byte[] bytes = nbt.func_74770_j("dataBytes");
            PacketBufferForestry data = new PacketBufferForestry(Unpooled.wrappedBuffer((byte[])bytes));
            try {
                streamable.readData(data);
            }
            catch (IOException e) {
                Log.error("Failed to read streamable data", e);
            }
        }
    }

    public static class NBTList<T extends INBT>
    extends ForwardingList<T> {
        private final ArrayList<T> backingList;

        public NBTList(ListNBT nbtList) {
            this.backingList = new ArrayList(nbtList.field_74747_a);
        }

        protected List<T> delegate() {
            return this.backingList;
        }
    }

    public static enum EnumNBTType {
        END(EndNBT.class),
        BYTE(ByteNBT.class),
        SHORT(ShortNBT.class),
        INT(IntNBT.class),
        LONG(LongNBT.class),
        FLOAT(FloatNBT.class),
        DOUBLE(DoubleNBT.class),
        BYTE_ARRAY(ByteArrayNBT.class),
        STRING(StringNBT.class),
        LIST(ListNBT.class),
        COMPOUND(CompoundNBT.class),
        INT_ARRAY(IntArrayNBT.class);

        public static final EnumNBTType[] VALUES;
        public final Class<? extends INBT> classObject;

        private EnumNBTType(Class<? extends INBT> c) {
            this.classObject = c;
        }

        static {
            VALUES = EnumNBTType.values();
        }
    }
}

