/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelTransform;

@OnlyIn(value=Dist.CLIENT)
public class ResourceUtil {
    private ResourceUtil() {
    }

    public static Minecraft client() {
        return Minecraft.func_71410_x();
    }

    public static IResourceManager resourceManager() {
        return ResourceUtil.client().func_195551_G();
    }

    public static TextureAtlasSprite getMissingTexture() {
        return ResourceUtil.getSprite(PlayerContainer.field_226615_c_, MissingTextureSprite.func_195675_b());
    }

    public static TextureAtlasSprite getSprite(ResourceLocation atlas, ResourceLocation sprite) {
        return (TextureAtlasSprite)ResourceUtil.client().func_228015_a_(atlas).apply(sprite);
    }

    public static TextureAtlasSprite getBlockSprite(ResourceLocation location) {
        return ResourceUtil.getSprite(PlayerContainer.field_226615_c_, location);
    }

    public static TextureAtlasSprite getBlockSprite(String location) {
        return ResourceUtil.getBlockSprite(new ResourceLocation(location));
    }

    public static boolean resourceExists(ResourceLocation location) {
        try {
            ResourceUtil.resourceManager().func_199002_a(location);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static BufferedReader createReader(IResource resource) {
        return new BufferedReader(new InputStreamReader(resource.func_199027_b(), StandardCharsets.UTF_8));
    }

    @Nullable
    public static IResource getResource(ResourceLocation location) {
        try {
            return ResourceUtil.resourceManager().func_199002_a(location);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static List<IResource> getResources(ResourceLocation location) {
        try {
            return ResourceUtil.resourceManager().func_199004_b(location);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    @Nullable
    public static IBakedModel getModel(ItemStack stack) {
        ItemRenderer renderItem = ResourceUtil.client().func_175599_af();
        if (renderItem == null || renderItem.func_175037_a() == null) {
            return null;
        }
        return renderItem.func_175037_a().func_178089_a(stack);
    }

    public static SimpleModelTransform loadTransform(ResourceLocation location) {
        return new SimpleModelTransform(PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)ResourceUtil.loadTransformFromJson(location)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ItemCameraTransforms loadTransformFromJson(ResourceLocation location) {
        try (Reader reader = ResourceUtil.getReaderForResource(location);){
            ItemCameraTransforms itemCameraTransforms = BlockModel.func_178307_a((Reader)reader).func_181682_g();
            return itemCameraTransforms;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ItemCameraTransforms.field_178357_a;
        }
    }

    private static Reader getReaderForResource(ResourceLocation location) throws IOException {
        ResourceLocation file = new ResourceLocation(location.func_110624_b(), "models/" + location.func_110623_a() + ".json");
        IResource iresource = ResourceUtil.resourceManager().func_199002_a(file);
        return new BufferedReader(new InputStreamReader(iresource.func_199027_b(), StandardCharsets.UTF_8));
    }
}

