/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.google.common.collect.AbstractIterator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;

public final class VectUtil {
    public static final Comparator<BlockPos> TOP_DOWN_COMPARATOR = (a, b) -> Integer.compare(b.func_177956_o(), a.func_177956_o());

    private VectUtil() {
    }

    public static BlockPos getRandomPositionInArea(Random random, Vector3i area) {
        int x = random.nextInt(area.func_177958_n());
        int y = random.nextInt(area.func_177956_o());
        int z = random.nextInt(area.func_177952_p());
        return new BlockPos(x, y, z);
    }

    public static BlockPos add(Vector3i ... vects) {
        int x = 0;
        int y = 0;
        int z = 0;
        for (Vector3i vect : vects) {
            x += vect.func_177958_n();
            y += vect.func_177956_o();
            z += vect.func_177952_p();
        }
        return new BlockPos(x, y, z);
    }

    public static BlockPos scale(Vector3i vect, float factor) {
        return new BlockPos((double)((float)vect.func_177958_n() * factor), (double)((float)vect.func_177956_o() * factor), (double)((float)vect.func_177952_p() * factor));
    }

    public static Direction direction(Vector3i a, Vector3i b) {
        int z;
        int y;
        int x = Math.abs(a.func_177958_n() - b.func_177958_n());
        int max = Math.max(x, Math.max(y = Math.abs(a.func_177956_o() - b.func_177956_o()), z = Math.abs(a.func_177952_p() - b.func_177952_p())));
        if (max == x) {
            return Direction.EAST;
        }
        if (max == z) {
            return Direction.SOUTH;
        }
        return Direction.UP;
    }

    public static Iterator<BlockPos.Mutable> getAllInBoxFromCenterMutable(World world, BlockPos from, BlockPos center, BlockPos to) {
        BlockPos minPos = new BlockPos(Math.min(from.func_177958_n(), to.func_177958_n()), Math.min(from.func_177956_o(), to.func_177956_o()), Math.min(from.func_177952_p(), to.func_177952_p()));
        BlockPos maxPos = new BlockPos(Math.max(from.func_177958_n(), to.func_177958_n()), Math.max(from.func_177956_o(), to.func_177956_o()), Math.max(from.func_177952_p(), to.func_177952_p()));
        return new MutableBlockPosSpiralIterator(world, center, maxPos, minPos);
    }

    private static class MutableBlockPosSpiralIterator
    extends AbstractIterator<BlockPos.Mutable> {
        private final World world;
        private final BlockPos center;
        private final BlockPos maxPos;
        private final BlockPos minPos;
        private int spiralLayer;
        private final int maxSpiralLayers;
        private int direction;
        @Nullable
        private BlockPos.Mutable theBlockPos;

        public MutableBlockPosSpiralIterator(World world, BlockPos center, BlockPos maxPos, BlockPos minPos) {
            this.world = world;
            this.center = center;
            this.maxPos = maxPos;
            this.minPos = minPos;
            int xDiameter = maxPos.func_177958_n() - minPos.func_177958_n();
            int zDiameter = maxPos.func_177952_p() - minPos.func_177952_p();
            this.maxSpiralLayers = Math.max(xDiameter, zDiameter) / 2;
            this.spiralLayer = 1;
        }

        @Nullable
        protected BlockPos.Mutable computeNext() {
            BlockPos.Mutable pos;
            while ((pos = this.nextPos()) != null && (pos.func_177958_n() > this.maxPos.func_177958_n() || pos.func_177956_o() > this.maxPos.func_177956_o() || pos.func_177952_p() > this.maxPos.func_177952_p() || pos.func_177958_n() < this.minPos.func_177958_n() || pos.func_177956_o() < this.minPos.func_177956_o() || pos.func_177952_p() < this.minPos.func_177952_p())) {
            }
            return pos;
        }

        @Nullable
        protected BlockPos.Mutable nextPos() {
            if (this.theBlockPos == null) {
                this.theBlockPos = new BlockPos.Mutable(this.center.func_177958_n(), this.maxPos.func_177956_o(), this.center.func_177952_p());
                int y = Math.min(this.maxPos.func_177956_o(), this.world.func_205770_a(Heightmap.Type.WORLD_SURFACE, (BlockPos)this.theBlockPos).func_177956_o());
                this.theBlockPos.func_185336_p(y);
                return this.theBlockPos;
            }
            if (this.spiralLayer > this.maxSpiralLayers) {
                return (BlockPos.Mutable)this.endOfData();
            }
            int x = this.theBlockPos.func_177958_n();
            int y = this.theBlockPos.func_177956_o();
            int z = this.theBlockPos.func_177952_p();
            if (y > this.minPos.func_177956_o() && y > 0) {
                --y;
            } else {
                switch (this.direction) {
                    case 0: {
                        if (++x != this.center.func_177958_n() + this.spiralLayer) break;
                        ++this.direction;
                        break;
                    }
                    case 1: {
                        if (++z != this.center.func_177952_p() + this.spiralLayer) break;
                        ++this.direction;
                        break;
                    }
                    case 2: {
                        if (--x != this.center.func_177958_n() - this.spiralLayer) break;
                        ++this.direction;
                        break;
                    }
                    case 3: {
                        if (--z != this.center.func_177952_p() - this.spiralLayer) break;
                        this.direction = 0;
                        ++this.spiralLayer;
                    }
                }
                this.theBlockPos.func_181079_c(x, y, z);
                y = Math.min(this.maxPos.func_177956_o(), this.world.func_205770_a(Heightmap.Type.WORLD_SURFACE, (BlockPos)this.theBlockPos).func_177956_o());
            }
            return this.theBlockPos.func_181079_c(x, y, z);
        }
    }
}

