/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.arboriculture.worldgen.ITreeBlockType;
import forestry.arboriculture.worldgen.TreeBlockType;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.utils.VectUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.VineBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class FeatureHelper {
    public static boolean addBlock(IWorld world, BlockPos pos, ITreeBlockType type, EnumReplaceMode replaceMode) {
        return FeatureHelper.addBlock(world, pos, type, replaceMode, TreeContour.EMPTY);
    }

    public static boolean addBlock(IWorld world, BlockPos pos, ITreeBlockType type, EnumReplaceMode replaceMode, TreeContour contour) {
        if (!world.func_175667_e(pos)) {
            return false;
        }
        BlockState blockState = world.func_180495_p(pos);
        if (replaceMode.canReplace(blockState, world, pos)) {
            type.setBlock(world, pos);
            contour.addLeaf(pos);
            return true;
        }
        return false;
    }

    public static void generateCylinderFromTreeStartPos(IWorld world, ITreeBlockType block, BlockPos startPos, int girth, float radius, int height, EnumReplaceMode replace, TreeContour contour) {
        FeatureHelper.generateCylinderFromPos(world, block, startPos.func_177982_a(girth / 2, 0, girth / 2), radius, height, replace, contour);
    }

    public static void generateCylinderFromPos(IWorld world, ITreeBlockType block, BlockPos center, float radius, int height, EnumReplaceMode replace, TreeContour contour) {
        BlockPos start = new BlockPos((double)((float)center.func_177958_n() - radius), (double)center.func_177956_o(), (double)((float)center.func_177952_p() - radius));
        int x = 0;
        while ((float)x < radius * 2.0f + 1.0f) {
            for (int y = height - 1; y >= 0; --y) {
                int z = 0;
                while ((float)z < radius * 2.0f + 1.0f) {
                    Vector3i treeCenter;
                    BlockPos position = start.func_177982_a(x, y, z);
                    if (position.func_218140_a((double)(treeCenter = new Vector3i(center.func_177958_n(), position.func_177956_o(), center.func_177952_p())).func_177958_n(), (double)treeCenter.func_177956_o(), (double)treeCenter.func_177952_p(), false) <= (double)(radius * radius) + 0.01) {
                        Direction direction = VectUtil.direction((Vector3i)position, treeCenter);
                        block.setDirection(direction);
                        if (FeatureHelper.addBlock(world, position, block, replace)) {
                            contour.addLeaf(position);
                        }
                    }
                    ++z;
                }
            }
            ++x;
        }
    }

    public static void generateCircleFromTreeStartPos(IWorld world, Random rand, BlockPos startPos, int girth, float radius, int width, int height, ITreeBlockType block, float chance, EnumReplaceMode replace, TreeContour contour) {
        FeatureHelper.generateCircle(world, rand, startPos.func_177982_a(girth / 2, 0, girth / 2), radius, width, height, block, chance, replace, contour);
    }

    public static void generateCircle(IWorld world, Random rand, BlockPos center, float radius, int width, int height, ITreeBlockType block, float chance, EnumReplaceMode replace, TreeContour contour) {
        Vector3i start = new Vector3i((double)((float)center.func_177958_n() - radius), (double)center.func_177956_o(), (double)((float)center.func_177952_p() - radius));
        Vector3i area = new Vector3i((double)(radius * 2.0f + 1.0f), (double)height, (double)(radius * 2.0f + 1.0f));
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (int x = start.func_177958_n(); x < start.func_177958_n() + area.func_177958_n(); ++x) {
            for (int y = start.func_177956_o() + area.func_177956_o() - 1; y >= start.func_177956_o(); --y) {
                for (int z = start.func_177952_p(); z < start.func_177952_p() + area.func_177952_p(); ++z) {
                    double distance;
                    if (rand.nextFloat() > chance || !(((double)(radius - (float)width) - 0.01) * ((double)(radius - (float)width) - 0.01) < (distance = mutablePos.func_181079_c(x, y, z).func_218140_a((double)center.func_177958_n(), (double)y, (double)center.func_177952_p(), false))) || !(distance <= ((double)radius + 0.01) * ((double)radius + 0.01)) || !FeatureHelper.addBlock(world, (BlockPos)mutablePos, block, replace)) continue;
                    contour.addLeaf((BlockPos)mutablePos);
                }
            }
        }
    }

    public static void generateSphereFromTreeStartPos(IWorld world, BlockPos startPos, int girth, int radius, ITreeBlockType block, EnumReplaceMode replace, TreeContour contour) {
        FeatureHelper.generateSphere(world, startPos.func_177982_a(girth / 2, 0, girth / 2), radius, block, replace, contour);
    }

    public static void generateSphere(IWorld world, BlockPos center, int radius, ITreeBlockType block, EnumReplaceMode replace, TreeContour contour) {
        Vector3i start = new Vector3i(center.func_177958_n() - radius, center.func_177956_o() - radius, center.func_177952_p() - radius);
        Vector3i area = new Vector3i(radius * 2 + 1, radius * 2 + 1, radius * 2 + 1);
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (int x = start.func_177958_n(); x < start.func_177958_n() + area.func_177958_n(); ++x) {
            for (int y = start.func_177956_o() + area.func_177956_o() - 1; y >= start.func_177956_o(); --y) {
                for (int z = start.func_177952_p(); z < start.func_177952_p() + area.func_177952_p(); ++z) {
                    if (!center.func_218141_a((Vector3i)mutablePos.func_181079_c(x, y, z), (double)radius + 0.01) || !FeatureHelper.addBlock(world, (BlockPos)mutablePos, block, replace)) continue;
                    contour.addLeaf((BlockPos)mutablePos);
                }
            }
        }
    }

    public static Set<BlockPos> generateTreeTrunk(IWorld world, Random rand, ITreeBlockType wood, BlockPos startPos, int height, int girth, int yStart, float vinesChance, @Nullable Direction leanDirection, float leanScale) {
        HashSet<BlockPos> treeTops = new HashSet<BlockPos>();
        int leanStartY = (int)Math.floor((float)height * 0.33f);
        int prevXOffset = 0;
        int prevZOffset = 0;
        int leanX = 0;
        int leanZ = 0;
        if (leanDirection != null) {
            leanX = leanDirection.func_82601_c();
            leanZ = leanDirection.func_82599_e();
        }
        for (int x = 0; x < girth; ++x) {
            for (int z = 0; z < girth; ++z) {
                for (int y = height - 1; y >= yStart; --y) {
                    float lean = y < leanStartY ? 0.0f : leanScale * (float)(y - leanStartY) / (float)(height - leanStartY);
                    int xOffset = (int)Math.floor((float)leanX * lean);
                    int zOffset = (int)Math.floor((float)leanZ * lean);
                    if (xOffset != prevXOffset || zOffset != prevZOffset) {
                        prevXOffset = xOffset;
                        prevZOffset = zOffset;
                        if (y > 0) {
                            if (leanDirection != null) {
                                wood.setDirection(leanDirection);
                            }
                            FeatureHelper.addBlock(world, startPos.func_177982_a(x + xOffset, y - 1, z + zOffset), wood, EnumReplaceMode.ALL);
                            wood.setDirection(Direction.UP);
                        }
                    }
                    BlockPos pos = startPos.func_177982_a(x + xOffset, y, z + zOffset);
                    FeatureHelper.addBlock(world, pos, wood, EnumReplaceMode.ALL);
                    FeatureHelper.addVines(world, rand, pos, vinesChance);
                    if (y + 1 != height) continue;
                    treeTops.add(pos);
                }
            }
        }
        return treeTops;
    }

    protected static void addVines(IWorld world, Random rand, BlockPos pos, float chance) {
        BlockState blockState;
        if (chance <= 0.0f) {
            return;
        }
        if (rand.nextFloat() < chance) {
            blockState = (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((Property)VineBlock.field_176278_M, (Comparable)Boolean.valueOf(true));
            FeatureHelper.addBlock(world, pos.func_177976_e(), new TreeBlockType(blockState), EnumReplaceMode.AIR);
        }
        if (rand.nextFloat() < chance) {
            blockState = (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((Property)VineBlock.field_176280_O, (Comparable)Boolean.valueOf(true));
            FeatureHelper.addBlock(world, pos.func_177974_f(), new TreeBlockType(blockState), EnumReplaceMode.AIR);
        }
        if (rand.nextFloat() < chance) {
            blockState = (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((Property)VineBlock.field_176279_N, (Comparable)Boolean.valueOf(true));
            FeatureHelper.addBlock(world, pos.func_177978_c(), new TreeBlockType(blockState), EnumReplaceMode.AIR);
        }
        if (rand.nextFloat() < chance) {
            blockState = (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((Property)VineBlock.field_176273_b, (Comparable)Boolean.valueOf(true));
            FeatureHelper.addBlock(world, pos.func_177968_d(), new TreeBlockType(blockState), EnumReplaceMode.AIR);
        }
    }

    public static void generatePods(ITreeGenData tree, IWorld world, Random rand, BlockPos startPos, int height, int minHeight, int girth, EnumReplaceMode replaceMode) {
        for (int y = height - 1; y >= minHeight; --y) {
            for (int x = 0; x < girth; ++x) {
                for (int z = 0; z < girth; ++z) {
                    if (x > 0 && x < girth && z > 0 && z < girth) continue;
                    FeatureHelper.trySpawnFruitBlock(tree, world, rand, startPos.func_177982_a(x + 1, y, z), replaceMode);
                    FeatureHelper.trySpawnFruitBlock(tree, world, rand, startPos.func_177982_a(x - 1, y, z), replaceMode);
                    FeatureHelper.trySpawnFruitBlock(tree, world, rand, startPos.func_177982_a(x, y, z + 1), replaceMode);
                    FeatureHelper.trySpawnFruitBlock(tree, world, rand, startPos.func_177982_a(x, y, z - 1), replaceMode);
                }
            }
        }
    }

    private static void trySpawnFruitBlock(ITreeGenData tree, IWorld world, Random rand, BlockPos pos, EnumReplaceMode replaceMode) {
        BlockState blockState = world.func_180495_p(pos);
        if (replaceMode.canReplace(blockState, world, pos)) {
            tree.trySpawnFruitBlock(world, rand, pos);
        }
    }

    public static void generateSupportStems(ITreeBlockType wood, IWorld world, Random rand, BlockPos startPos, int height, int girth, float chance, float maxHeight) {
        int min = -1;
        for (int x = -1; x <= girth; ++x) {
            for (int z = -1; z <= girth; ++z) {
                if (x == -1 && z == -1 || x == girth && z == girth || x == -1 && z == girth || x == girth && z == -1) continue;
                int stemHeight = rand.nextInt(Math.round((float)height * maxHeight));
                if (!(rand.nextFloat() < chance)) continue;
                for (int y = 0; y < stemHeight; ++y) {
                    FeatureHelper.addBlock(world, startPos.func_177982_a(x, y, z), wood, EnumReplaceMode.SOFT);
                }
            }
        }
    }

    public static Set<BlockPos> generateBranches(IWorld world, Random rand, ITreeBlockType wood, BlockPos startPos, int girth, float spreadY, float spreadXZ, int radius, int count, float chance) {
        HashSet<BlockPos> branchEnds = new HashSet<BlockPos>();
        if (radius < 1) {
            radius = 1;
        }
        for (Direction branchDirection : Direction.Plane.HORIZONTAL) {
            wood.setDirection(branchDirection);
            BlockPos branchStart = startPos;
            int offsetX = branchDirection.func_82601_c();
            int offsetZ = branchDirection.func_82599_e();
            if (offsetX > 0) {
                branchStart = branchStart.func_177982_a(girth - 1, 0, 0);
            }
            if (offsetZ > 0) {
                branchStart = branchStart.func_177982_a(0, 0, girth - 1);
            }
            for (int i = 0; i < count; ++i) {
                if (rand.nextFloat() > chance) continue;
                int y = 0;
                int x = 0;
                int z = 0;
                BlockPos branchEnd = null;
                for (int r = 0; r < radius; ++r) {
                    if (rand.nextFloat() < spreadY) {
                        ++y;
                        wood.setDirection(Direction.UP);
                    } else if (rand.nextFloat() < spreadXZ) {
                        if (branchDirection.func_176740_k() == Direction.Axis.Z) {
                            x = rand.nextBoolean() ? ++x : --x;
                            wood.setDirection(Direction.EAST);
                        } else if (branchDirection.func_176740_k() == Direction.Axis.X) {
                            z = rand.nextBoolean() ? ++z : --z;
                            wood.setDirection(Direction.SOUTH);
                        }
                    } else {
                        x += offsetX;
                        z += offsetZ;
                        wood.setDirection(branchDirection);
                    }
                    BlockPos pos = branchStart.func_177982_a(x, y, z);
                    if (!FeatureHelper.addBlock(world, pos, wood, EnumReplaceMode.SOFT)) break;
                    branchEnd = pos;
                }
                if (branchEnd == null) continue;
                branchEnds.add(branchEnd);
            }
        }
        return branchEnds;
    }

    public static class DirectionHelper {
        public static final Direction[] VALUES = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};

        public static Direction getRandom(Random random) {
            return VALUES[random.nextInt(VALUES.length)];
        }

        public static Direction getRandomOther(Random random, Direction direction) {
            List<Direction> directions = Arrays.asList(VALUES);
            directions.remove(direction);
            int size = directions.size();
            return directions.toArray(new Direction[size])[random.nextInt(size)];
        }
    }

    public static enum EnumReplaceMode {
        AIR{

            @Override
            public boolean canReplace(BlockState blockState, IWorld world, BlockPos pos) {
                return world.func_175623_d(pos);
            }
        }
        ,
        ALL{

            @Override
            public boolean canReplace(BlockState blockState, IWorld world, BlockPos pos) {
                return true;
            }
        }
        ,
        SOFT{

            @Override
            public boolean canReplace(BlockState blockState, IWorld world, BlockPos pos) {
                if (world instanceof World) {
                    DirectionalPlaceContext context = new DirectionalPlaceContext((World)world, pos, Direction.DOWN, ItemStack.field_190927_a, Direction.UP);
                    return blockState.func_196953_a((BlockItemUseContext)context);
                }
                return blockState.func_185904_a().func_76222_j();
            }
        };


        public abstract boolean canReplace(BlockState var1, IWorld var2, BlockPos var3);
    }
}

