/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.core.features.CoreItems;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.widgets.TankWidget;
import forestry.cultivation.gui.ContainerPlanter;
import forestry.cultivation.gui.widgets.GhostItemStackWidget;
import forestry.cultivation.inventory.InventoryPlanter;
import forestry.cultivation.tiles.TilePlanter;
import forestry.farming.gui.FarmLedger;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;

public class GuiPlanter
extends GuiForestryTitled<ContainerPlanter> {
    private final TilePlanter tile;

    public GuiPlanter(ContainerPlanter container, PlayerInventory playerInventory, ITextComponent title) {
        super("textures/gui/planter.png", container, playerInventory, title);
        int index;
        int j;
        int i;
        this.tile = (TilePlanter)container.getTile();
        this.field_146999_f = 202;
        this.field_147000_g = 192;
        NonNullList<ItemStack> resourceStacks = this.tile.createResourceStacks();
        NonNullList<ItemStack> germlingStacks = this.tile.createGermlingStacks();
        NonNullList<ItemStack> productionStacks = this.tile.createProductionStacks();
        this.widgetManager.add(new TankWidget(this.widgetManager, 178, 44, 0).setOverlayOrigin(this.field_146999_f, 18));
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 2; ++j) {
                index = j + i * 2;
                if (resourceStacks.size() != 4) continue;
                this.widgetManager.add(new GhostItemStackWidget(this.widgetManager, 11 + j * 18, 65 + i * 18, (ItemStack)resourceStacks.get(index), ((ContainerPlanter)this.func_212873_a_()).func_75139_a(36 + InventoryPlanter.CONFIG.resourcesStart + index)));
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 2; ++j) {
                index = j + i * 2;
                if (germlingStacks.size() != 4) continue;
                this.widgetManager.add(new GhostItemStackWidget(this.widgetManager, 71 + j * 18, 65 + i * 18, (ItemStack)germlingStacks.get(index), ((ContainerPlanter)this.func_212873_a_()).func_75139_a(36 + InventoryPlanter.CONFIG.germlingsStart + index)));
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 2; ++j) {
                index = j + i * 2;
                if (productionStacks.size() != 4) continue;
                this.widgetManager.add(new GhostItemStackWidget(this.widgetManager, 131 + j * 18, 65 + i * 18, (ItemStack)productionStacks.get(index), ((ContainerPlanter)this.func_212873_a_()).func_75139_a(36 + InventoryPlanter.CONFIG.productionStart + j + i * 2)));
            }
        }
        this.widgetManager.add(new GhostItemStackWidget(this.widgetManager, 83, 22, CoreItems.FERTILIZER_COMPOUND.stack(), ((ContainerPlanter)this.func_212873_a_()).func_75139_a(36 + InventoryPlanter.CONFIG.fertilizerStart)));
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.tile);
        this.addClimateLedger(this.tile);
        this.ledgerManager.add(new FarmLedger(this.ledgerManager, this.tile.getFarmLedgerDelegate()));
        this.addOwnerLedger(this.tile);
        this.addPowerLedger(this.tile.getEnergyManager());
    }

    @Override
    protected void func_230450_a_(MatrixStack transform, float partialTicks, int mouseY, int mouseX) {
        super.func_230450_a_(transform, partialTicks, mouseY, mouseX);
        int fertilizerRemain = this.tile.getStoredFertilizerScaled(16);
        if (fertilizerRemain > 0) {
            this.func_238474_b_(transform, this.field_147003_i + 101, this.field_147009_r + 21 + 17 - fertilizerRemain, this.field_146999_f, 17 - fertilizerRemain, 4, fertilizerRemain);
        }
    }
}

