/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import forestry.api.recipes.ICarpenterRecipe;
import forestry.factory.recipes.RecipeSerializers;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateRecipesPacket;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CarpenterRecipe
implements ICarpenterRecipe {
    private final ResourceLocation id;
    private final int packagingTime;
    private final FluidStack liquid;
    private final Ingredient box;
    private final ICraftingRecipe recipe;
    private final ItemStack result;

    public CarpenterRecipe(ResourceLocation id, int packagingTime, FluidStack liquid, Ingredient box, ICraftingRecipe recipe, @Nullable ItemStack result) {
        Preconditions.checkNotNull((Object)id, (Object)"Recipe identifier cannot be null");
        Preconditions.checkNotNull((Object)box);
        Preconditions.checkNotNull((Object)recipe);
        this.id = id;
        this.packagingTime = packagingTime;
        this.liquid = liquid;
        this.box = box;
        this.recipe = recipe;
        this.result = result != null ? result : recipe.func_77571_b();
    }

    @Override
    public int getPackagingTime() {
        return this.packagingTime;
    }

    @Override
    public Ingredient getBox() {
        return this.box;
    }

    @Override
    public FluidStack getFluidResource() {
        return this.liquid;
    }

    @Override
    public ICraftingRecipe getCraftingGridRecipe() {
        return this.recipe;
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CarpenterRecipe> {
        public CarpenterRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int packagingTime = JSONUtils.func_151203_m((JsonObject)json, (String)"time");
            FluidStack liquid = json.has("liquid") ? RecipeSerializers.deserializeFluid(JSONUtils.func_152754_s((JsonObject)json, (String)"liquid")) : FluidStack.EMPTY;
            Ingredient box = RecipeSerializers.deserialize(json.get("box"));
            ICraftingRecipe internal = (ICraftingRecipe)RecipeManager.func_215377_a((ResourceLocation)recipeId, (JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"recipe"));
            ItemStack result = json.has("result") ? RecipeSerializers.item(JSONUtils.func_152754_s((JsonObject)json, (String)"result")) : internal.func_77571_b();
            return new CarpenterRecipe(recipeId, packagingTime, liquid, box, internal, result);
        }

        public CarpenterRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int packagingTime = buffer.func_150792_a();
            FluidStack liquid = buffer.readBoolean() ? FluidStack.readFromPacket((PacketBuffer)buffer) : FluidStack.EMPTY;
            Ingredient box = Ingredient.func_199566_b((PacketBuffer)buffer);
            ICraftingRecipe internal = (ICraftingRecipe)SUpdateRecipesPacket.func_218772_c((PacketBuffer)buffer);
            ItemStack result = buffer.func_150791_c();
            return new CarpenterRecipe(recipeId, packagingTime, liquid, box, internal, result);
        }

        public void toNetwork(PacketBuffer buffer, CarpenterRecipe recipe) {
            buffer.func_150787_b(recipe.packagingTime);
            if (!recipe.liquid.isEmpty()) {
                buffer.writeBoolean(true);
                recipe.liquid.writeToPacket(buffer);
            } else {
                buffer.writeBoolean(false);
            }
            recipe.box.func_199564_a(buffer);
            SUpdateRecipesPacket.func_218771_a((IRecipe)recipe.recipe, (PacketBuffer)buffer);
            buffer.func_150788_a(recipe.result);
        }
    }
}

