/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.factory.recipes.RecipeSerializers;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CentrifugeRecipe
implements ICentrifugeRecipe {
    private final ResourceLocation id;
    private final int processingTime;
    private final Ingredient input;
    private final NonNullList<ICentrifugeRecipe.Product> outputs;

    public CentrifugeRecipe(ResourceLocation id, int processingTime, Ingredient input, NonNullList<ICentrifugeRecipe.Product> outputs) {
        Preconditions.checkNotNull((Object)id, (Object)"Recipe identifier cannot be null");
        this.id = id;
        this.processingTime = processingTime;
        this.input = input;
        this.outputs = outputs;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public NonNullList<ItemStack> getProducts(Random random) {
        NonNullList products = NonNullList.func_191196_a();
        for (ICentrifugeRecipe.Product entry : this.outputs) {
            float probability = entry.getProbability();
            if ((double)probability >= 1.0) {
                products.add((Object)entry.getStack().func_77946_l());
                continue;
            }
            if (!(random.nextFloat() < probability)) continue;
            products.add((Object)entry.getStack().func_77946_l());
        }
        return products;
    }

    @Override
    public NonNullList<ICentrifugeRecipe.Product> getAllProducts() {
        return this.outputs;
    }

    @Override
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CentrifugeRecipe> {
        public CentrifugeRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int processingTime = JSONUtils.func_151203_m((JsonObject)json, (String)"time");
            Ingredient input = RecipeSerializers.deserialize(json.get("input"));
            NonNullList outputs = NonNullList.func_191196_a();
            for (JsonElement element : JSONUtils.func_151214_t((JsonObject)json, (String)"products")) {
                float chance = JSONUtils.func_151217_k((JsonObject)element.getAsJsonObject(), (String)"chance");
                ItemStack stack = RecipeSerializers.item(JSONUtils.func_152754_s((JsonObject)element.getAsJsonObject(), (String)"item"));
                outputs.add((Object)new ICentrifugeRecipe.Product(chance, stack));
            }
            return new CentrifugeRecipe(recipeId, processingTime, input, (NonNullList<ICentrifugeRecipe.Product>)outputs);
        }

        public CentrifugeRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int processingTime = buffer.func_150792_a();
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            NonNullList<ICentrifugeRecipe.Product> outputs = RecipeSerializers.read(buffer, b -> {
                float chance = b.readFloat();
                ItemStack stack = b.func_150791_c();
                return new ICentrifugeRecipe.Product(chance, stack);
            });
            return new CentrifugeRecipe(recipeId, processingTime, input, outputs);
        }

        public void toNetwork(PacketBuffer buffer, CentrifugeRecipe recipe) {
            buffer.func_150787_b(recipe.processingTime);
            recipe.input.func_199564_a(buffer);
            RecipeSerializers.write(buffer, recipe.outputs, (b, product) -> {
                b.writeFloat(product.getProbability());
                b.func_150788_a(product.getStack());
            });
        }
    }
}

