/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.recipes.ICentrifugeManager;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.api.recipes.IForestryRecipe;
import forestry.factory.recipes.AbstractCraftingProvider;
import forestry.factory.recipes.CentrifugeRecipe;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.NonNullList;

public class CentrifugeRecipeManager
extends AbstractCraftingProvider<ICentrifugeRecipe>
implements ICentrifugeManager {
    public CentrifugeRecipeManager() {
        super(ICentrifugeRecipe.TYPE);
    }

    @Override
    public void addRecipe(int timePerItem, ItemStack resource, Map<ItemStack, Float> products) {
        NonNullList list = NonNullList.func_191196_a();
        for (Map.Entry<ItemStack, Float> entry : products.entrySet()) {
            list.add((Object)new ICentrifugeRecipe.Product(entry.getValue().floatValue(), entry.getKey()));
        }
        CentrifugeRecipe recipe = new CentrifugeRecipe(IForestryRecipe.anonymous(), timePerItem, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{resource}), (NonNullList<ICentrifugeRecipe.Product>)list);
        this.addRecipe(recipe);
    }

    @Override
    @Nullable
    public ICentrifugeRecipe findMatchingRecipe(@Nullable RecipeManager recipeManager, ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        for (ICentrifugeRecipe recipe : this.getRecipes(recipeManager)) {
            Ingredient recipeInput = recipe.getInput();
            if (!recipeInput.test(itemStack)) continue;
            return recipe;
        }
        return null;
    }
}

