/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.recipes.IFabricatorSmeltingManager;
import forestry.api.recipes.IFabricatorSmeltingRecipe;
import forestry.api.recipes.IForestryRecipe;
import forestry.factory.recipes.AbstractCraftingProvider;
import forestry.factory.recipes.FabricatorSmeltingRecipe;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FabricatorSmeltingRecipeManager
extends AbstractCraftingProvider<IFabricatorSmeltingRecipe>
implements IFabricatorSmeltingManager {
    public FabricatorSmeltingRecipeManager() {
        super(IFabricatorSmeltingRecipe.TYPE);
    }

    @Override
    @Nullable
    public IFabricatorSmeltingRecipe findMatchingSmelting(@Nullable RecipeManager recipeManager, ItemStack resource) {
        if (resource.func_190926_b()) {
            return null;
        }
        for (IFabricatorSmeltingRecipe smelting : this.getRecipes(recipeManager)) {
            if (!smelting.getResource().test(resource)) continue;
            return smelting;
        }
        return null;
    }

    @Override
    public void addSmelting(ItemStack resource, FluidStack molten, int meltingPoint) {
        this.addRecipe(new FabricatorSmeltingRecipe(IForestryRecipe.anonymous(), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{resource}), molten, meltingPoint));
    }

    @Override
    public Set<ResourceLocation> getRecipeFluids(@Nullable RecipeManager recipeManager) {
        return this.getRecipes(recipeManager).stream().map(IFabricatorSmeltingRecipe::getProduct).filter(fluidStack -> !fluidStack.isEmpty()).map(fluidStack -> fluidStack.getFluid().getRegistryName()).collect(Collectors.toSet());
    }
}

