/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.fermenter;

import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.IFermenterRecipe;
import forestry.api.recipes.IVariableFermentable;
import forestry.core.recipes.jei.ForestryRecipeWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FermenterRecipeWrapper
extends ForestryRecipeWrapper<IFermenterRecipe> {
    private final ItemStack fermentable;

    public FermenterRecipeWrapper(IFermenterRecipe recipe, ItemStack fermentable) {
        super(recipe);
        this.fermentable = fermentable;
    }

    public void setIngredients(IIngredients ingredients) {
        ArrayList<ItemStack> fuelInputs = new ArrayList<ItemStack>();
        for (FermenterFuel fuel : FuelManager.fermenterFuel.values()) {
            fuelInputs.add(fuel.getItem());
        }
        ingredients.setInputLists(VanillaTypes.ITEM, Arrays.asList(Collections.singletonList(this.fermentable), fuelInputs));
        FluidStack fluidInput = ((IFermenterRecipe)this.getRecipe()).getFluidResource().copy();
        fluidInput.setAmount(((IFermenterRecipe)this.getRecipe()).getFermentationValue());
        ingredients.setInput(VanillaTypes.FLUID, (Object)fluidInput);
        int amount = Math.round((float)((IFermenterRecipe)this.getRecipe()).getFermentationValue() * ((IFermenterRecipe)this.getRecipe()).getModifier());
        if (this.fermentable.func_77973_b() instanceof IVariableFermentable) {
            amount = (int)((float)amount * ((IVariableFermentable)this.fermentable.func_77973_b()).getFermentationModifier(this.fermentable));
        }
        FluidStack fluidOutput = new FluidStack(((IFermenterRecipe)this.getRecipe()).getOutput(), amount);
        ingredients.setOutput(VanillaTypes.FLUID, (Object)fluidOutput);
    }
}

