/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import com.google.common.base.Preconditions;
import forestry.api.core.IErrorLogic;
import forestry.api.recipes.IStillRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.network.PacketBufferForestry;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.factory.features.FactoryTiles;
import forestry.factory.gui.ContainerStill;
import forestry.factory.inventory.InventoryStill;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileStill
extends TilePowered
implements ISidedInventory,
ILiquidTankTile {
    private static final int ENERGY_PER_RECIPE_TIME = 200;
    private final FilteredTank resourceTank;
    private final FilteredTank productTank;
    private final TankManager tankManager;
    @Nullable
    private IStillRecipe currentRecipe;
    private FluidStack bufferedLiquid;

    public TileStill() {
        super(FactoryTiles.STILL.tileType(), 1100, 8000);
        this.setInternalInventory(new InventoryStill(this));
        this.resourceTank = new FilteredTank(10000, true, true);
        this.resourceTank.setFilters(() -> RecipeManagers.stillManager.getRecipeFluidInputs(this.field_145850_b.func_199532_z()));
        this.productTank = new FilteredTank(10000, false, true);
        this.resourceTank.setFilters(() -> RecipeManagers.stillManager.getRecipeFluidOutputs(this.field_145850_b.func_199532_z()));
        this.tankManager = new TankManager(this, this.resourceTank, this.productTank);
        this.bufferedLiquid = FluidStack.EMPTY;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT = super.func_189515_b(compoundNBT);
        this.tankManager.write(compoundNBT);
        if (!this.bufferedLiquid.isEmpty()) {
            CompoundNBT buffer = new CompoundNBT();
            this.bufferedLiquid.writeToNBT(buffer);
            compoundNBT.func_218657_a("Buffer", (INBT)buffer);
        }
        return compoundNBT;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        super.func_230337_a_(state, compoundNBT);
        this.tankManager.read(compoundNBT);
        if (compoundNBT.func_74764_b("Buffer")) {
            CompoundNBT buffer = compoundNBT.func_74775_l("Buffer");
            this.bufferedLiquid = FluidStack.loadFluidStackFromNBT((CompoundNBT)buffer);
        }
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 2);
            FluidStack fluidStack = this.productTank.getFluid();
            if (!fluidStack.isEmpty()) {
                FluidHelper.fillContainers(this.tankManager, (IInventory)this, 1, 0, fluidStack.getFluid(), true);
            }
        }
    }

    @Override
    public boolean workCycle() {
        Preconditions.checkNotNull((Object)this.currentRecipe);
        int cycles = this.currentRecipe.getCyclesPerUnit();
        FluidStack output = this.currentRecipe.getOutput();
        FluidStack product = new FluidStack(output, output.getAmount() * cycles);
        this.productTank.fillInternal(product, IFluidHandler.FluidAction.EXECUTE);
        this.bufferedLiquid = FluidStack.EMPTY;
        return true;
    }

    private void checkRecipe() {
        FluidStack recipeLiquid;
        FluidStack fluidStack = recipeLiquid = !this.bufferedLiquid.isEmpty() ? this.bufferedLiquid : this.resourceTank.getFluid();
        if (!RecipeManagers.stillManager.matches(this.currentRecipe, recipeLiquid)) {
            this.currentRecipe = RecipeManagers.stillManager.findMatchingRecipe(this.field_145850_b.func_199532_z(), recipeLiquid);
            int recipeTime = this.currentRecipe == null ? 0 : this.currentRecipe.getCyclesPerUnit();
            this.setEnergyPerWorkCycle(200 * recipeTime);
            this.setTicksPerWorkCycle(recipeTime);
        }
    }

    @Override
    public boolean hasWork() {
        this.checkRecipe();
        boolean hasRecipe = this.currentRecipe != null;
        boolean hasTankSpace = true;
        boolean hasLiquidResource = true;
        if (hasRecipe) {
            FluidStack fluidStack = this.currentRecipe.getOutput();
            boolean bl = hasTankSpace = this.productTank.fillInternal(fluidStack, IFluidHandler.FluidAction.SIMULATE) == fluidStack.getAmount();
            if (this.bufferedLiquid.isEmpty()) {
                FluidStack input;
                int cycles = this.currentRecipe.getCyclesPerUnit();
                int drainAmount = cycles * (input = this.currentRecipe.getInput()).getAmount();
                FluidStack drained = this.resourceTank.drain(drainAmount, IFluidHandler.FluidAction.SIMULATE);
                boolean bl2 = hasLiquidResource = !drained.isEmpty() && drained.getAmount() == drainAmount;
                if (hasLiquidResource) {
                    this.bufferedLiquid = new FluidStack(input, drainAmount);
                    this.resourceTank.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasRecipe, EnumErrorCode.NO_RECIPE);
        errorLogic.setCondition(!hasTankSpace, EnumErrorCode.NO_SPACE_TANK);
        errorLogic.setCondition(!hasLiquidResource, EnumErrorCode.NO_RESOURCE_LIQUID);
        return hasRecipe && hasLiquidResource && hasTankSpace;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    @Override
    public TankRenderInfo getProductTankInfo() {
        return new TankRenderInfo((IFluidTank)this.productTank);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.tankManager).cast();
        }
        return super.getCapability(capability, facing);
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerStill(windowId, player.field_71071_by, this);
    }
}

