/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import forestry.api.core.IErrorLogic;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IExtentCache;
import forestry.api.farming.IFarmListener;
import forestry.api.farming.IFarmLogic;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.StandardTank;
import forestry.core.fluids.TankManager;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.cultivation.IFarmHousingInternal;
import forestry.farming.FarmHelper;
import forestry.farming.FarmTarget;
import forestry.farming.multiblock.FarmFertilizerManager;
import forestry.farming.multiblock.FarmHydrationManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class FarmManager
implements INbtReadable,
INbtWritable,
IStreamable,
IExtentCache {
    private final Map<FarmDirection, List<FarmTarget>> targets = new EnumMap<FarmDirection, List<FarmTarget>>(FarmDirection.class);
    private final Table<FarmDirection, BlockPos, Integer> lastExtents = HashBasedTable.create();
    private final IFarmHousingInternal housing;
    @Nullable
    private IFarmLogic harvestProvider;
    private final List<ICrop> pendingCrops = new LinkedList<ICrop>();
    private final Stack<ItemStack> pendingProduce = new Stack();
    private FarmHelper.Stage stage = FarmHelper.Stage.CULTIVATE;
    private final Set<IFarmListener> farmListeners = new HashSet<IFarmListener>();
    private final FarmHydrationManager hydrationManager;
    private final FarmFertilizerManager fertilizerManager;
    private final TankManager tankManager;
    private final StandardTank resourceTank;
    private int farmWorkTicks = 0;

    public FarmManager(IFarmHousingInternal housing) {
        this.housing = housing;
        this.resourceTank = new FilteredTank(10000).setFilters(new Fluid[]{Fluids.field_204546_a});
        this.tankManager = new TankManager(housing, this.resourceTank);
        this.hydrationManager = new FarmHydrationManager(housing);
        this.fertilizerManager = new FarmFertilizerManager(housing);
    }

    public FarmHydrationManager getHydrationManager() {
        return this.hydrationManager;
    }

    public TankManager getTankManager() {
        return this.tankManager;
    }

    public FarmFertilizerManager getFertilizerManager() {
        return this.fertilizerManager;
    }

    public StandardTank getResourceTank() {
        return this.resourceTank;
    }

    public void addListener(IFarmListener listener) {
        this.farmListeners.add(listener);
    }

    public void removeListener(IFarmListener listener) {
        this.farmListeners.remove(listener);
    }

    public boolean doWork() {
        ++this.farmWorkTicks;
        if (this.targets.isEmpty() || this.farmWorkTicks % 20 == 0) {
            this.housing.setUpFarmlandTargets(this.targets);
        }
        IErrorLogic errorLogic = this.housing.getErrorLogic();
        if (!this.pendingProduce.isEmpty()) {
            boolean added = this.housing.getFarmInventory().tryAddPendingProduce(this.pendingProduce);
            errorLogic.setCondition(!added, EnumErrorCode.NO_SPACE_INVENTORY);
            return added;
        }
        boolean hasFertilizer = this.fertilizerManager.maintainFertilizer();
        if (errorLogic.setCondition(!hasFertilizer, EnumErrorCode.NO_FERTILIZER)) {
            return false;
        }
        if (!this.pendingCrops.isEmpty() && this.harvestProvider != null) {
            ICrop first = this.pendingCrops.get(0);
            if (this.cullCrop(first, this.harvestProvider)) {
                this.pendingCrops.remove(0);
                return true;
            }
            return false;
        }
        FarmHelper.FarmWorkStatus farmWorkStatus = new FarmHelper.FarmWorkStatus();
        World world = this.housing.getWorldObj();
        List<FarmDirection> farmDirections = Arrays.asList(FarmDirection.values());
        Collections.shuffle(farmDirections, world.field_73012_v);
        for (FarmDirection farmSide : farmDirections) {
            IFarmLogic logic = this.housing.getFarmLogic(farmSide);
            List<FarmTarget> farmTargets = this.targets.get((Object)farmSide);
            if (this.stage == FarmHelper.Stage.CULTIVATE) {
                for (FarmTarget target : farmTargets) {
                    if (target.getExtent() <= 0) continue;
                    farmWorkStatus.hasFarmland = true;
                    break;
                }
            }
            if (FarmHelper.isCycleCanceledByListeners(logic, farmSide, this.farmListeners)) continue;
            if (this.collectWindfall(logic)) {
                farmWorkStatus.didWork = true;
            }
            if (this.stage == FarmHelper.Stage.HARVEST) {
                Collection<ICrop> harvested = FarmHelper.harvestTargets(world, this.housing, farmTargets, logic, this.farmListeners);
                boolean bl = farmWorkStatus.didWork = !harvested.isEmpty();
                if (!harvested.isEmpty()) {
                    this.pendingCrops.addAll(harvested);
                    this.pendingCrops.sort(FarmHelper.TopDownICropComparator.INSTANCE);
                    this.harvestProvider = logic;
                }
            } else if (this.stage == FarmHelper.Stage.CULTIVATE) {
                this.cultivateTargets(farmWorkStatus, farmTargets, logic, farmSide);
            }
            if (!farmWorkStatus.didWork) continue;
            break;
        }
        if (this.stage == FarmHelper.Stage.CULTIVATE) {
            errorLogic.setCondition(!farmWorkStatus.hasFarmland, EnumErrorCode.NO_FARMLAND);
            errorLogic.setCondition(!farmWorkStatus.hasFertilizer, EnumErrorCode.NO_FERTILIZER);
            errorLogic.setCondition(!farmWorkStatus.hasLiquid, EnumErrorCode.NO_LIQUID_FARM);
        }
        this.stage = this.stage.next();
        return farmWorkStatus.didWork;
    }

    private void cultivateTargets(FarmHelper.FarmWorkStatus farmWorkStatus, List<FarmTarget> farmTargets, IFarmLogic logic, FarmDirection farmSide) {
        World world = this.housing.getWorldObj();
        if (farmWorkStatus.hasFarmland && !FarmHelper.isCycleCanceledByListeners(logic, farmSide, this.farmListeners)) {
            float hydrationModifier = this.hydrationManager.getHydrationModifier();
            int fertilizerConsumption = Math.round((float)logic.getProperties().getFertilizerConsumption(this.housing) * Config.fertilizerModifier);
            int liquidConsumption = logic.getProperties().getWaterConsumption(this.housing, hydrationModifier);
            FluidStack liquid = new FluidStack((Fluid)Fluids.field_204546_a, liquidConsumption);
            for (FarmTarget target : farmTargets) {
                if (!this.fertilizerManager.hasFertilizer(fertilizerConsumption)) {
                    farmWorkStatus.hasFertilizer = false;
                    continue;
                }
                if (liquid.getAmount() > 0 && !this.housing.hasLiquid(liquid)) {
                    farmWorkStatus.hasLiquid = false;
                    continue;
                }
                if (!FarmHelper.cultivateTarget(world, this.housing, target, logic, this.farmListeners)) continue;
                this.fertilizerManager.removeFertilizer(fertilizerConsumption);
                this.housing.removeLiquid(liquid);
                farmWorkStatus.didWork = true;
            }
        }
    }

    private boolean collectWindfall(IFarmLogic logic) {
        NonNullList<ItemStack> collected = logic.collect(this.housing.getWorldObj(), this.housing);
        if (collected.isEmpty()) {
            return false;
        }
        for (IFarmListener listener : this.farmListeners) {
            listener.hasCollected(collected, logic);
        }
        this.housing.getFarmInventory().stowProducts((Iterable<ItemStack>)collected, this.pendingProduce);
        return true;
    }

    private boolean cullCrop(ICrop crop, IFarmLogic provider) {
        boolean hasFertilizer;
        for (IFarmListener listener : this.farmListeners) {
            if (!listener.beforeCropHarvest(crop)) continue;
            return true;
        }
        int fertilizerConsumption = Math.round((float)provider.getProperties().getFertilizerConsumption(this.housing) * Config.fertilizerModifier);
        IErrorLogic errorLogic = this.housing.getErrorLogic();
        if (errorLogic.setCondition(!(hasFertilizer = this.fertilizerManager.hasFertilizer(fertilizerConsumption)), EnumErrorCode.NO_FERTILIZER)) {
            return false;
        }
        float hydrationModifier = this.hydrationManager.getHydrationModifier();
        int waterConsumption = provider.getProperties().getWaterConsumption(this.housing, hydrationModifier);
        FluidStack requiredLiquid = new FluidStack((Fluid)Fluids.field_204546_a, waterConsumption);
        boolean hasLiquid = requiredLiquid.getAmount() == 0 || this.housing.hasLiquid(requiredLiquid);
        if (errorLogic.setCondition(!hasLiquid, EnumErrorCode.NO_LIQUID_FARM)) {
            return false;
        }
        NonNullList<ItemStack> harvested = crop.harvest();
        if (harvested != null) {
            this.fertilizerManager.removeFertilizer(fertilizerConsumption);
            this.housing.removeLiquid(requiredLiquid);
            for (IFarmListener listener : this.farmListeners) {
                listener.afterCropHarvest(harvested, crop);
            }
            this.housing.getFarmInventory().stowProducts((Iterable<ItemStack>)harvested, this.pendingProduce);
        }
        return true;
    }

    @Override
    public CompoundNBT write(CompoundNBT data) {
        this.hydrationManager.write(data);
        this.tankManager.write(data);
        this.fertilizerManager.write(data);
        return data;
    }

    @Override
    public void read(CompoundNBT data) {
        this.hydrationManager.read(data);
        this.tankManager.read(data);
        this.fertilizerManager.read(data);
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        this.tankManager.writeData(data);
        this.hydrationManager.writeData(data);
        this.fertilizerManager.writeData(data);
    }

    @Override
    public void readData(PacketBufferForestry data) throws IOException {
        this.tankManager.readData(data);
        this.hydrationManager.readData(data);
        this.fertilizerManager.readData(data);
    }

    public void clearTargets() {
        this.targets.clear();
    }

    public void addPendingProduct(ItemStack stack) {
        this.pendingProduce.add(stack);
    }

    public BlockPos getFarmCorner(FarmDirection direction) {
        List<FarmTarget> targetList = this.targets.get((Object)direction);
        if (targetList.isEmpty()) {
            return this.housing.getCoords();
        }
        FarmTarget target = targetList.get(0);
        return target.getStart().func_177972_a(direction.getFacing().func_176734_d());
    }

    @Override
    public int getExtents(FarmDirection direction, BlockPos pos) {
        if (!this.lastExtents.contains((Object)direction, (Object)pos)) {
            this.lastExtents.put((Object)direction, (Object)pos, (Object)0);
            return 0;
        }
        return (Integer)this.lastExtents.get((Object)direction, (Object)pos);
    }

    @Override
    public void setExtents(FarmDirection direction, BlockPos pos, int extend) {
        this.lastExtents.put((Object)direction, (Object)pos, (Object)extend);
    }

    @Override
    public void cleanExtents(FarmDirection direction) {
        this.lastExtents.row((Object)direction).clear();
    }
}

