/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmProperties;
import forestry.api.farming.IFarmable;
import forestry.api.farming.Soil;
import forestry.core.utils.VectUtil;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public abstract class FarmLogic
implements IFarmLogic {
    private final EntitySelectorFarm entitySelectorFarm;
    protected final IFarmProperties properties;
    protected final boolean isManual;

    public FarmLogic(IFarmProperties properties, boolean isManual) {
        this.properties = properties;
        this.isManual = isManual;
        this.entitySelectorFarm = new EntitySelectorFarm(properties);
    }

    protected Collection<IFarmable> getFarmables() {
        return this.properties.getFarmables();
    }

    protected Collection<Soil> getSoils() {
        return this.properties.getSoils();
    }

    @Override
    public IFarmProperties getProperties() {
        return this.properties;
    }

    @Override
    public boolean isManual() {
        return this.isManual;
    }

    @Override
    public Collection<ICrop> harvest(World world, IFarmHousing housing, FarmDirection direction, int extent, BlockPos pos) {
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            BlockPos position = this.translateWithOffset(pos.func_177984_a(), direction, i);
            ICrop crop = this.getCrop(world, position);
            if (crop == null) continue;
            crops.push(crop);
        }
        return crops;
    }

    @Nullable
    protected ICrop getCrop(World world, BlockPos position) {
        if (!world.func_175667_e(position) || world.func_175623_d(position)) {
            return null;
        }
        BlockState blockState = world.func_180495_p(position);
        for (IFarmable seed : this.getFarmables()) {
            ICrop crop = seed.getCropAt(world, position, blockState);
            if (crop == null) continue;
            return crop;
        }
        return null;
    }

    @Deprecated
    public boolean isAcceptedWindfall(ItemStack stack) {
        return false;
    }

    protected final boolean isWaterSourceBlock(World world, BlockPos position) {
        if (!world.func_175667_e(position)) {
            return false;
        }
        BlockState blockState = world.func_180495_p(position);
        Block block = blockState.func_177230_c();
        return block == Blocks.field_150355_j;
    }

    protected final boolean isIceBlock(World world, BlockPos position) {
        if (!world.func_175667_e(position)) {
            return false;
        }
        BlockState blockState = world.func_180495_p(position);
        Block block = blockState.func_177230_c();
        return block == Blocks.field_150432_aD;
    }

    protected final BlockPos translateWithOffset(BlockPos pos, FarmDirection farmDirection, int step) {
        return VectUtil.scale(farmDirection.getFacing().func_176730_m(), step).func_177971_a((Vector3i)pos);
    }

    private static AxisAlignedBB getHarvestBox(World world, IFarmHousing farmHousing, boolean toWorldHeight) {
        BlockPos coords = farmHousing.getCoords();
        Vector3i area = farmHousing.getArea();
        Vector3i offset = farmHousing.getOffset();
        BlockPos min = coords.func_177971_a(offset);
        BlockPos max = min.func_177971_a(area);
        int maxY = max.func_177956_o();
        if (toWorldHeight) {
            maxY = world.func_217301_I();
        }
        return new AxisAlignedBB((double)min.func_177958_n(), (double)min.func_177956_o(), (double)min.func_177952_p(), (double)max.func_177958_n(), (double)maxY, (double)max.func_177952_p());
    }

    protected NonNullList<ItemStack> collectEntityItems(World world, IFarmHousing farmHousing, boolean toWorldHeight) {
        AxisAlignedBB harvestBox = FarmLogic.getHarvestBox(world, farmHousing, toWorldHeight);
        List entityItems = world.func_175647_a(ItemEntity.class, harvestBox, (Predicate)((Object)this.entitySelectorFarm));
        NonNullList stacks = NonNullList.func_191196_a();
        for (ItemEntity entity : entityItems) {
            ItemStack contained = entity.func_92059_d();
            stacks.add((Object)contained.func_77946_l());
            entity.func_70106_y();
        }
        return stacks;
    }

    public String toString() {
        return this.properties.getTranslationKey();
    }

    private static class EntitySelectorFarm
    implements com.google.common.base.Predicate<ItemEntity> {
        private final IFarmProperties properties;

        public EntitySelectorFarm(IFarmProperties properties) {
            this.properties = properties;
        }

        public boolean apply(@Nullable ItemEntity entity) {
            if (entity == null || !entity.func_70089_S()) {
                return false;
            }
            if (entity.getPersistentData().func_74767_n("PreventRemoteMovement")) {
                return false;
            }
            ItemStack contained = entity.func_92059_d();
            return this.properties.isAcceptedSeedling(contained) || this.properties.isAcceptedWindfall(contained);
        }
    }
}

