/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmProperties;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.FarmLogicWatered;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmLogicGourd
extends FarmLogicWatered {
    public FarmLogicGourd(IFarmProperties properties, boolean isManual) {
        super(properties, isManual);
    }

    @Override
    protected boolean maintainCrops(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        BlockPos position;
        for (int i = 0; i < extent && world.func_175667_e(position = this.translateWithOffset(pos, direction, i)); ++i) {
            BlockState groundState;
            BlockState state = world.func_180495_p(position);
            if (!world.func_175623_d(position) && !BlockUtil.isReplaceableBlock(state, world, position) || !this.isValidPosition(farmHousing, direction, position, FarmLogicWatered.CultivationType.CROP) || !this.isAcceptedSoil(groundState = world.func_180495_p(position.func_177977_b()))) continue;
            return this.trySetCrop(world, farmHousing, position, direction);
        }
        return false;
    }

    private boolean trySetCrop(World world, IFarmHousing farmHousing, BlockPos position, FarmDirection direction) {
        for (IFarmable candidate : this.getFarmables()) {
            if (!farmHousing.plantGermling(candidate, world, position, direction)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isValidPosition(IFarmHousing housing, FarmDirection direction, BlockPos position, FarmLogicWatered.CultivationType type) {
        BlockPos farmLocation = housing.getFarmCorner(direction).func_177972_a(direction.getFacing());
        int xVal = farmLocation.func_177958_n() & 1;
        int zVal = farmLocation.func_177952_p() & 1;
        boolean uneven = (position.func_177958_n() & 1) != xVal ^ (position.func_177952_p() & 1) != zVal;
        return type == FarmLogicWatered.CultivationType.WATER != uneven;
    }
}

