/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.models;

import forestry.core.models.ModelBlockCached;
import forestry.core.models.baker.ModelBaker;
import forestry.farming.blocks.BlockFarm;
import forestry.farming.blocks.EnumFarmBlockType;
import forestry.farming.blocks.EnumFarmMaterial;
import forestry.farming.features.FarmingBlocks;
import forestry.modules.features.FeatureBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class ModelFarmBlock
extends ModelBlockCached<BlockFarm, Pair<BlockFarm, BlockFarm.State>> {
    public ModelFarmBlock() {
        super(BlockFarm.class);
    }

    @Override
    protected Pair<BlockFarm, BlockFarm.State> getInventoryKey(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block instanceof BlockFarm) {
            return Pair.of((Object)((Object)((BlockFarm)block)), (Object)((Object)BlockFarm.State.PLAIN));
        }
        return Pair.of(((FeatureBlock)FarmingBlocks.FARM.get(EnumFarmBlockType.PLAIN, EnumFarmMaterial.BRICK)).block(), (Object)((Object)BlockFarm.State.PLAIN));
    }

    @Override
    protected Pair<BlockFarm, BlockFarm.State> getWorldKey(BlockState state, IModelData extraData) {
        Block block = state.func_177230_c();
        if (block instanceof BlockFarm) {
            return Pair.of((Object)((Object)((BlockFarm)block)), (Object)state.func_177229_b(BlockFarm.STATE));
        }
        return Pair.of(((FeatureBlock)FarmingBlocks.FARM.get(EnumFarmBlockType.PLAIN, EnumFarmMaterial.BRICK)).block(), (Object)((Object)BlockFarm.State.PLAIN));
    }

    @Override
    protected void bakeBlock(BlockFarm blockFarm, IModelData extraData, Pair<BlockFarm, BlockFarm.State> key, ModelBaker baker, boolean inventory) {
        EnumFarmBlockType type = ((BlockFarm)((Object)key.getLeft())).getType();
        EnumFarmMaterial material = ((BlockFarm)((Object)key.getLeft())).getFarmMaterial();
        TextureAtlasSprite[] textures = material.getSprites();
        baker.addBlockModel(textures, 0);
        baker.addBlockModel(type.getSprites(), 0);
        if (type == EnumFarmBlockType.PLAIN && key.getRight() == BlockFarm.State.BAND) {
            baker.addBlockModel(EnumFarmBlockType.getBandSprites(), 0);
        }
        baker.setParticleSprite(textures[0]);
    }
}

