/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import com.mojang.authlib.GameProfile;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IBreedingTrackerHandler;
import forestry.api.genetics.alleles.IAlleleForestrySpecies;
import forestry.api.genetics.gatgets.IDatabasePlugin;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.api.lepidopterology.ILepidopteristTracker;
import forestry.api.lepidopterology.genetics.ButterflyChromosomes;
import forestry.api.lepidopterology.genetics.EnumFlutterType;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.api.lepidopterology.genetics.IButterflyRoot;
import forestry.core.genetics.root.BreedingTrackerManager;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.EntityUtil;
import forestry.core.utils.GeneticsUtil;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.features.LepidopterologyBlocks;
import forestry.lepidopterology.features.LepidopterologyEntities;
import forestry.lepidopterology.genetics.Butterfly;
import forestry.lepidopterology.genetics.ButterflyPlugin;
import forestry.lepidopterology.genetics.FlutterlyzerPlugin;
import forestry.lepidopterology.genetics.LepidopteristTracker;
import forestry.lepidopterology.tiles.TileCocoon;
import genetics.api.individual.IGenome;
import genetics.api.individual.IGenomeWrapper;
import genetics.api.individual.IIndividual;
import genetics.api.root.IRootContext;
import genetics.api.root.IndividualRoot;
import genetics.utils.AlleleUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ButterflyRoot
extends IndividualRoot<IButterfly>
implements IButterflyRoot,
IBreedingTrackerHandler {
    private int butterflySpeciesCount = -1;
    public static final String UID = "rootButterflies";
    private static final List<IButterfly> butterflyTemplates = new ArrayList<IButterfly>();

    public ButterflyRoot(IRootContext<IButterfly> context) {
        super(context);
        BreedingTrackerManager.INSTANCE.registerTracker(UID, this);
    }

    @Override
    public IButterfly create(CompoundNBT compound) {
        return new Butterfly(compound);
    }

    @Override
    public IButterfly create(IGenome genome) {
        return new Butterfly(genome);
    }

    @Override
    public IButterfly create(IGenome genome, IGenome mate) {
        return new Butterfly(genome, mate);
    }

    @Override
    public IGenomeWrapper createWrapper(IGenome genome) {
        return () -> genome;
    }

    @Override
    public Class<? extends IButterfly> getMemberClass() {
        return IButterfly.class;
    }

    @Override
    public int getSpeciesCount() {
        if (this.butterflySpeciesCount < 0) {
            this.butterflySpeciesCount = (int)AlleleUtils.filteredStream(ButterflyChromosomes.SPECIES).filter(IAlleleForestrySpecies::isCounted).count();
        }
        return this.butterflySpeciesCount;
    }

    @Override
    public EnumFlutterType getIconType() {
        return EnumFlutterType.BUTTERFLY;
    }

    @Override
    public boolean isMember(IIndividual individual) {
        return individual instanceof IButterfly;
    }

    public EntityButterfly spawnButterflyInWorld(World world, IButterfly butterfly, double x, double y, double z) {
        return EntityUtil.spawnEntity(world, EntityButterfly.create(LepidopterologyEntities.BUTTERFLY.entityType(), world, butterfly, new BlockPos(x, y, z)), x, y, z);
    }

    @Override
    public BlockPos plantCocoon(IWorld world, BlockPos coordinates, @Nullable IButterfly caterpillar, GameProfile owner, int age, boolean createNursery) {
        if (caterpillar == null) {
            return BlockPos.field_177992_a;
        }
        BlockPos pos = this.getValidCocoonPos(world, coordinates, caterpillar, owner, createNursery);
        if (pos == BlockPos.field_177992_a) {
            return pos;
        }
        BlockState state = LepidopterologyBlocks.COCOON.defaultState();
        boolean placed = world.func_180501_a(pos, state, 18);
        if (!placed) {
            return BlockPos.field_177992_a;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!LepidopterologyBlocks.COCOON.blockEqual(block)) {
            return BlockPos.field_177992_a;
        }
        TileCocoon cocoon = TileUtil.getTile((IBlockReader)world, pos, TileCocoon.class);
        if (cocoon == null) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 18);
            return BlockPos.field_177992_a;
        }
        cocoon.setCaterpillar(caterpillar);
        cocoon.getOwnerHandler().setOwner(owner);
        cocoon.setAge(age);
        return pos;
    }

    private BlockPos getValidCocoonPos(IWorld world, BlockPos pos, IButterfly caterpillar, GameProfile gameProfile, boolean createNursery) {
        if (this.isPositionValid(world, pos.func_177977_b(), caterpillar, gameProfile, createNursery)) {
            return pos.func_177977_b();
        }
        for (int tries = 0; tries < 3; ++tries) {
            for (int y = 1; y < world.func_201674_k().nextInt(5); ++y) {
                BlockPos coordinate = pos.func_177982_a(world.func_201674_k().nextInt(6) - 3, -y, world.func_201674_k().nextInt(6) - 3);
                if (!this.isPositionValid(world, coordinate, caterpillar, gameProfile, createNursery)) continue;
                return coordinate;
            }
        }
        return BlockPos.field_177992_a;
    }

    public boolean isPositionValid(IWorld world, BlockPos pos, IButterfly caterpillar, GameProfile gameProfile, boolean createNursery) {
        BlockState blockState = world.func_180495_p(pos);
        if (BlockUtil.canReplace(blockState, world, pos)) {
            BlockPos nurseryPos = pos.func_177984_a();
            IButterflyNursery nursery = GeneticsUtil.getNursery(world, nurseryPos);
            if (this.isNurseryValid(nursery, caterpillar, gameProfile)) {
                return true;
            }
            if (createNursery && GeneticsUtil.canCreateNursery(world, nurseryPos)) {
                nursery = GeneticsUtil.getOrCreateNursery(gameProfile, world, nurseryPos, false);
                return this.isNurseryValid(nursery, caterpillar, gameProfile);
            }
        }
        return false;
    }

    private boolean isNurseryValid(@Nullable IButterflyNursery nursery, IButterfly caterpillar, GameProfile gameProfile) {
        return nursery != null && nursery.canNurse(caterpillar);
    }

    @Override
    public boolean isMated(ItemStack stack) {
        IButterfly butterfly = this.getTypes().createIndividual(stack).orElse(null);
        return butterfly != null && !butterfly.getMate().isPresent();
    }

    @Override
    public ILepidopteristTracker getBreedingTracker(IWorld world, @Nullable GameProfile player) {
        return (ILepidopteristTracker)BreedingTrackerManager.INSTANCE.getTracker(this.getUID(), world, player);
    }

    @Override
    public String getFileName(@Nullable GameProfile profile) {
        return "LepidopteristTracker." + (profile == null ? "common" : profile.getId());
    }

    @Override
    public IBreedingTracker createTracker(String fileName) {
        return new LepidopteristTracker(fileName);
    }

    @Override
    public void populateTracker(IBreedingTracker tracker, @Nullable World world, @Nullable GameProfile profile) {
        if (!(tracker instanceof LepidopteristTracker)) {
            return;
        }
        LepidopteristTracker arboristTracker = (LepidopteristTracker)tracker;
        arboristTracker.setWorld(world);
        arboristTracker.setUsername(profile);
    }

    @Override
    public IAlyzerPlugin getAlyzerPlugin() {
        return FlutterlyzerPlugin.INSTANCE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IDatabasePlugin getSpeciesPlugin() {
        return ButterflyPlugin.INSTANCE;
    }
}

