/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import forestry.api.lepidopterology.genetics.ButterflyChromosomes;
import forestry.api.lepidopterology.genetics.IAlleleButterflyCocoon;
import forestry.core.models.AbstractItemModel;
import genetics.api.GeneticHelper;
import genetics.api.organism.IOrganism;
import genetics.utils.AlleleUtils;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class CocoonItemModel
extends AbstractItemModel {
    private final ImmutableMap<String, ImmutableList<IBakedModel>> bakedModel;

    public CocoonItemModel(ImmutableMap<String, ImmutableList<IBakedModel>> bakedModel) {
        this.bakedModel = bakedModel;
    }

    @Override
    protected IBakedModel getOverride(IBakedModel model, ItemStack stack) {
        int age = MathHelper.func_76125_a((int)stack.func_196082_o().func_74762_e("Age"), (int)0, (int)3);
        IOrganism organism = GeneticHelper.getOrganism(stack);
        IAlleleButterflyCocoon alleleCocoon = organism.getAllele(ButterflyChromosomes.COCOON, true);
        return (IBakedModel)((ImmutableList)this.bakedModel.getOrDefault((Object)alleleCocoon.getCocoonName(), (Object)ImmutableList.of())).get(age);
    }

    public static class Loader
    implements IModelLoader<Geometry> {
        public void func_195410_a(IResourceManager resourceManager) {
        }

        public Geometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return new Geometry();
        }
    }

    private static class Geometry
    implements IModelGeometry<Geometry> {
        private Geometry() {
        }

        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
            ImmutableMap.Builder bakedModels = new ImmutableMap.Builder();
            AlleleUtils.forEach(ButterflyChromosomes.COCOON, allele -> {
                ImmutableList.Builder models = new ImmutableList.Builder();
                for (int age = 0; age < 3; ++age) {
                    models.add((Object)bakery.getBakedModel((ResourceLocation)allele.getCocoonItemModel(age), modelTransform, spriteGetter));
                }
                bakedModels.put((Object)allele.getCocoonName(), (Object)models.build());
            });
            return new CocoonItemModel((ImmutableMap<String, ImmutableList<IBakedModel>>)bakedModels.build());
        }

        public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return ImmutableList.of();
        }
    }
}

