/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import com.google.common.base.Preconditions;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.PostManager;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.utils.InventoryUtil;
import forestry.mail.Letter;
import forestry.mail.MailAddress;
import forestry.mail.POBoxInfo;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.storage.WorldSavedData;

public class POBox
extends WorldSavedData
implements IInventory {
    public static final String SAVE_NAME = "pobox_";
    public static final short SLOT_SIZE = 84;
    @Nullable
    private IMailAddress address;
    private final InventoryAdapter letters = new InventoryAdapter(84, "Letters").disableAutomation();

    public POBox(IMailAddress address) {
        super(SAVE_NAME + address);
        if (address.getType() != EnumAddressee.PLAYER) {
            throw new IllegalArgumentException("POBox address must be a player");
        }
        this.address = address;
    }

    public POBox(String savename) {
        super(savename);
    }

    public void func_76184_a(CompoundNBT compoundNBT) {
        if (compoundNBT.func_74764_b("address")) {
            this.address = new MailAddress(compoundNBT.func_74775_l("address"));
        }
        this.letters.read(compoundNBT);
    }

    public CompoundNBT func_189551_b(CompoundNBT compoundNBT) {
        if (this.address != null) {
            CompoundNBT nbt = new CompoundNBT();
            this.address.write(nbt);
            compoundNBT.func_218657_a("address", (INBT)nbt);
        }
        this.letters.write(compoundNBT);
        return compoundNBT;
    }

    public boolean storeLetter(ItemStack letterstack) {
        ILetter letter = PostManager.postRegistry.getLetter(letterstack);
        Preconditions.checkNotNull((Object)letter, (Object)"Letter stack must be a valid letter");
        letter.setProcessed(true);
        letter.invalidatePostage();
        CompoundNBT compoundNBT = new CompoundNBT();
        letter.write(compoundNBT);
        letterstack.func_77982_d(compoundNBT);
        this.func_76185_a();
        return InventoryUtil.tryAddStack((IInventory)this.letters, letterstack, true);
    }

    public POBoxInfo getPOBoxInfo() {
        int playerLetters = 0;
        int tradeLetters = 0;
        for (int i = 0; i < this.letters.func_70302_i_(); ++i) {
            CompoundNBT tagCompound;
            if (this.letters.func_70301_a(i).func_190926_b() || (tagCompound = this.letters.func_70301_a(i).func_77978_p()) == null) continue;
            Letter letter = new Letter(tagCompound);
            if (letter.getSender().getType() == EnumAddressee.PLAYER) {
                ++playerLetters;
                continue;
            }
            ++tradeLetters;
        }
        return new POBoxInfo(playerLetters, tradeLetters);
    }

    public boolean func_191420_l() {
        return this.letters.func_191420_l();
    }

    public void func_76185_a() {
        super.func_76185_a();
        this.letters.func_70296_d();
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.func_76185_a();
        this.letters.func_70299_a(var1, var2);
    }

    public int func_70302_i_() {
        return this.letters.func_70302_i_();
    }

    public ItemStack func_70301_a(int var1) {
        return this.letters.func_70301_a(var1);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return this.letters.func_70298_a(var1, var2);
    }

    public ItemStack func_70304_b(int index) {
        return this.letters.func_70304_b(index);
    }

    public int func_70297_j_() {
        return this.letters.func_70297_j_();
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(PlayerEntity var1) {
        return this.letters.func_70300_a(var1);
    }

    public void func_174889_b(PlayerEntity var1) {
    }

    public void func_174886_c(PlayerEntity var1) {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.letters.func_94041_b(i, itemstack);
    }

    public void func_174888_l() {
    }
}

