/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import forestry.api.core.IBlockSubtype;
import forestry.api.core.IFeatureSubtype;
import forestry.api.core.IItemProvider;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureGroup;
import forestry.modules.features.IBlockFeature;
import forestry.modules.features.IFeatureRegistry;
import forestry.modules.features.IItemFeature;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;

public class FeatureBlockGroup<B extends Block, S extends IBlockSubtype>
extends FeatureGroup<Builder<B, S>, FeatureBlock<B, BlockItem>, S> {
    private FeatureBlockGroup(Builder<B, S> builder) {
        super(builder);
    }

    @Override
    protected FeatureBlock<B, BlockItem> createFeature(Builder<B, S> builder, S type) {
        return builder.registry.block(() -> (Block)builder.constructor.apply(type), builder.itemConstructor != null ? block -> (BlockItem)builder.itemConstructor.apply(block, type) : null, builder.getIdentifier((IFeatureSubtype)type));
    }

    public Collection<B> getBlocks() {
        return this.featureByType.values().stream().map(IBlockFeature::block).collect(Collectors.toList());
    }

    public Collection<BlockItem> getItems() {
        return this.featureByType.values().stream().filter(IItemProvider::hasItem).map(IItemFeature::item).collect(Collectors.toList());
    }

    @Nullable
    public BlockState findState(String typeName) {
        Optional<BlockState> block = this.featureByType.entrySet().stream().filter(e -> ((IBlockSubtype)e.getKey()).func_176610_l().equals(typeName)).findFirst().flatMap(e -> Optional.of(e.getValue()));
        return block.map(FeatureBlock::defaultState).orElse(null);
    }

    public boolean blockEqual(BlockState state) {
        return this.getFeatures().stream().anyMatch(f -> f.blockEqual(state));
    }

    public boolean blockEqual(Block block) {
        return this.getFeatures().stream().anyMatch(f -> f.blockEqual(block));
    }

    public Block[] blockArray() {
        return this.getBlocks().toArray(new Block[0]);
    }

    public static class Builder<B extends Block, S extends IBlockSubtype>
    extends FeatureGroup.Builder<S, FeatureBlockGroup<B, S>> {
        private final IFeatureRegistry registry;
        private final Function<S, B> constructor;
        @Nullable
        private BiFunction<B, S, BlockItem> itemConstructor;

        public Builder(IFeatureRegistry registry, Function<S, B> constructor) {
            super(registry);
            this.registry = registry;
            this.constructor = constructor;
        }

        public Builder<B, S> itemWithType(BiFunction<B, S, BlockItem> itemConstructor) {
            this.itemConstructor = itemConstructor;
            return this;
        }

        public Builder<B, S> item(Function<B, BlockItem> itemConstructor) {
            this.itemConstructor = (block, type) -> (BlockItem)itemConstructor.apply(block);
            return this;
        }

        @Override
        public FeatureBlockGroup<B, S> create() {
            return new FeatureBlockGroup(this);
        }
    }
}

