/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import com.google.common.collect.ImmutableTable;
import forestry.api.core.IFeatureSubtype;
import forestry.api.core.IItemProvider;
import forestry.modules.features.FeatureGroup;
import forestry.modules.features.IFeatureRegistry;
import forestry.modules.features.IModFeature;
import forestry.modules.features.StackOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class FeatureTable<B extends Builder<R, C, ? extends FeatureTable<B, F, R, C>>, F extends IModFeature, R extends IFeatureSubtype, C extends IFeatureSubtype> {
    protected final ImmutableTable<R, C, F> featureByTypes;

    public FeatureTable(B builder) {
        ImmutableTable.Builder mapBuilder = new ImmutableTable.Builder();
        for (IFeatureSubtype row : ((Builder)builder).rowTypes) {
            for (IFeatureSubtype column : ((Builder)builder).columnTypes) {
                mapBuilder.put((Object)row, (Object)column, this.createFeature(builder, row, column));
            }
        }
        this.featureByTypes = mapBuilder.build();
    }

    protected abstract F createFeature(B var1, R var2, C var3);

    public boolean has(R rowType, C columnType) {
        return this.featureByTypes.contains(rowType, columnType);
    }

    public F get(R rowType, C columnType) {
        return (F)((IModFeature)this.featureByTypes.get(rowType, columnType));
    }

    public ImmutableTable<R, C, F> getFeatureByTypes() {
        return this.featureByTypes;
    }

    public Collection<F> getRowFeatures(R rowType) {
        return this.featureByTypes.row(rowType).values();
    }

    public Collection<F> getColumnFeatures(C rowType) {
        return this.featureByTypes.column(rowType).values();
    }

    public Collection<F> getFeatures() {
        return this.featureByTypes.values();
    }

    public boolean itemEqual(ItemStack stack) {
        return this.getFeatures().stream().filter(f -> f instanceof IItemProvider).map(f -> (IItemProvider)((Object)f)).anyMatch(f -> f.itemEqual(stack));
    }

    public boolean itemEqual(Item item) {
        return this.getFeatures().stream().filter(f -> f instanceof IItemProvider).map(f -> (IItemProvider)((Object)f)).anyMatch(f -> f.itemEqual(item));
    }

    public ItemStack stack(R rowType, C columnType) {
        return this.stack(rowType, columnType, 1);
    }

    public ItemStack stack(R rowType, C columnType, int amount) {
        IModFeature featureBlock = (IModFeature)this.featureByTypes.get(rowType, columnType);
        if (!(featureBlock instanceof IItemProvider)) {
            throw new IllegalStateException("This feature group has no item registered for the given sub type to create a stack for.");
        }
        return ((IItemProvider)((Object)featureBlock)).stack(amount);
    }

    public ItemStack stack(R rowType, C columnType, StackOption ... options) {
        IModFeature featureBlock = (IModFeature)this.featureByTypes.get(rowType, columnType);
        if (!(featureBlock instanceof IItemProvider)) {
            throw new IllegalStateException("This feature group has no item registered for the given sub type to create a stack for.");
        }
        return ((IItemProvider)((Object)featureBlock)).stack(options);
    }

    public static abstract class Builder<R extends IFeatureSubtype, C extends IFeatureSubtype, G> {
        protected final IFeatureRegistry registry;
        protected final Set<R> rowTypes = new HashSet<R>();
        protected final Set<C> columnTypes = new HashSet<C>();
        protected FeatureGroup.IdentifierType identifierType = FeatureGroup.IdentifierType.TYPE_ONLY;
        protected String identifier = "";

        public Builder(IFeatureRegistry registry) {
            this.registry = registry;
        }

        public Builder<R, C, G> identifier(String identifier) {
            return this.identifier(identifier, FeatureGroup.IdentifierType.PREFIX);
        }

        public Builder<R, C, G> identifier(String identifier, FeatureGroup.IdentifierType type) {
            this.identifier = identifier;
            this.identifierType = type;
            return this;
        }

        public Builder<R, C, G> rowType(R type) {
            this.rowTypes.add(type);
            return this;
        }

        public Builder<R, C, G> rowTypes(R[] types) {
            return this.rowTypes(Arrays.asList(types));
        }

        public Builder<R, C, G> rowTypes(Collection<R> types) {
            this.rowTypes.addAll(types);
            return this;
        }

        public Builder<R, C, G> columnType(C type) {
            this.columnTypes.add(type);
            return this;
        }

        public Builder<R, C, G> columnTypes(C[] types) {
            return this.columnTypes(Arrays.asList(types));
        }

        public Builder<R, C, G> columnTypes(Collection<C> types) {
            this.columnTypes.addAll(types);
            return this;
        }

        protected String getIdentifier(IFeatureSubtype rowType, IFeatureSubtype columnType) {
            return (String)this.identifierType.apply(this.identifier, rowType.func_176610_l() + "_" + columnType.func_176610_l());
        }

        public abstract G create();
    }
}

