/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting;

import forestry.api.genetics.alleles.AlleleManager;
import forestry.api.genetics.filter.IFilterData;
import forestry.api.genetics.filter.IFilterRule;
import forestry.api.genetics.filter.IFilterRuleType;
import forestry.core.render.TextureManagerForestry;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum DefaultFilterRuleType implements IFilterRuleType
{
    CLOSED(false){

        @Override
        public boolean isValid(ItemStack itemStack, IFilterData data) {
            return false;
        }
    }
    ,
    ANYTHING(false){

        @Override
        public boolean isValid(ItemStack itemStack, IFilterData data) {
            return true;
        }
    }
    ,
    ITEM(false){

        @Override
        public boolean isValid(ItemStack itemStack, IFilterData data) {
            return !data.isPresent();
        }
    }
    ,
    PURE_BREED,
    NOCTURNAL,
    PURE_NOCTURNAL,
    FLYER,
    PURE_FLYER,
    CAVE,
    PURE_CAVE;

    private final String uid = "forestry.default." + this.name().toLowerCase(Locale.ENGLISH);
    private final Set<IFilterRule> logic = new HashSet<IFilterRule>();
    private final boolean isContainer;

    private DefaultFilterRuleType() {
        this(true);
    }

    private DefaultFilterRuleType(boolean isContainer) {
        this.isContainer = isContainer;
    }

    public static void init() {
        for (DefaultFilterRuleType rule : DefaultFilterRuleType.values()) {
            AlleleManager.filterRegistry.registerFilter(rule);
        }
    }

    @Override
    public boolean isValid(ItemStack itemStack, IFilterData data) {
        for (IFilterRule logic : this.logic) {
            if (!logic.isValid(itemStack, data)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addLogic(IFilterRule logic) {
        if (logic == this) {
            throw new IllegalArgumentException();
        }
        this.logic.add(logic);
    }

    @Override
    public boolean isContainer() {
        return this.isContainer;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getSprite() {
        return TextureManagerForestry.getInstance().getDefault("analyzer/" + this.name().toLowerCase(Locale.ENGLISH));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTextureMap() {
        return TextureManagerForestry.LOCATION_FORESTRY_TEXTURE;
    }

    @Override
    public String getUID() {
        return this.uid;
    }
}

