/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.genetics.filter.IFilterLogic;
import forestry.core.gui.Drawable;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetScrollBar;
import forestry.sorting.gui.ContainerGeneticFilter;
import forestry.sorting.gui.ISelectableProvider;
import forestry.sorting.gui.SlotGeneticFilter;
import forestry.sorting.gui.widgets.RuleWidget;
import forestry.sorting.gui.widgets.SelectionWidget;
import forestry.sorting.gui.widgets.SpeciesWidget;
import forestry.sorting.tiles.IFilterContainer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiGeneticFilter
extends GuiForestryTitled<ContainerGeneticFilter> {
    private final IFilterContainer tile;
    private final WidgetScrollBar scrollBar;
    public final SelectionWidget selection;
    @Nullable
    private TextFieldWidget searchField;

    public GuiGeneticFilter(ContainerGeneticFilter container, PlayerInventory inventory, ITextComponent title) {
        super("textures/gui/filter.png", container, inventory, title);
        int i;
        this.field_147000_g = 222;
        this.field_146999_f = 212;
        this.tile = (IFilterContainer)container.getTile();
        for (i = 0; i < 6; ++i) {
            Direction facing = Direction.func_82600_a((int)i);
            this.widgetManager.add(new RuleWidget(this.widgetManager, 44, 18 + i * 18, facing, this));
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 2; ++k) {
                    this.widgetManager.add(new SpeciesWidget(this.widgetManager, 80 + j * 45 + k * 18, 18 + i * 18, Direction.func_82600_a((int)i), j, k == 0, this));
                }
            }
        }
        this.scrollBar = new WidgetScrollBar(this.widgetManager, 193, 150, 12, 64, new Drawable(new ResourceLocation("textures/gui/container/creative_inventory/tabs.png"), 232, 0, 12, 15));
        this.selection = new SelectionWidget(this.widgetManager, 0, 134, this.scrollBar, this);
        this.widgetManager.add(this.selection);
        this.widgetManager.add(this.scrollBar);
        this.scrollBar.setVisible(false);
    }

    public <S> void onModuleClick(ISelectableProvider<S> provider) {
        if (this.selection.isSame(provider)) {
            this.deselectFilter();
        } else {
            this.selectFilter(provider);
        }
    }

    private <S> void selectFilter(ISelectableProvider<S> provider) {
        this.selection.setProvider(provider);
        if (this.searchField != null) {
            this.searchField.func_146184_c(true);
            this.searchField.func_146189_e(true);
        }
        this.selection.filterEntries(this.searchField != null ? this.searchField.func_146179_b() : "");
        for (Slot slot : ((ContainerGeneticFilter)this.container).field_75151_b) {
            if (!(slot instanceof SlotGeneticFilter)) continue;
            SlotGeneticFilter filter = (SlotGeneticFilter)slot;
            filter.setEnabled(false);
        }
    }

    private void deselectFilter() {
        this.selection.setProvider(null);
        if (this.searchField != null) {
            this.searchField.func_146184_c(false);
            this.searchField.func_146189_e(false);
        }
        this.scrollBar.setVisible(false);
        for (Slot slot : ((ContainerGeneticFilter)this.container).field_75151_b) {
            if (!(slot instanceof SlotGeneticFilter)) continue;
            SlotGeneticFilter filter = (SlotGeneticFilter)slot;
            filter.setEnabled(true);
        }
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        String oldString = this.searchField != null ? this.searchField.func_146179_b() : "";
        FontRenderer fontRenderer = this.field_230706_i_.field_71466_p;
        int n = this.field_147003_i + this.selection.getX() + 89 + 36;
        int n2 = this.selection.getY() + this.field_147009_r + 4;
        this.field_230706_i_.field_71466_p.getClass();
        this.searchField = new TextFieldWidget(fontRenderer, n, n2, 80, 9, null);
        this.searchField.func_146203_f(50);
        this.searchField.func_146185_a(false);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_146180_a(oldString);
    }

    @Override
    protected void func_230450_a_(MatrixStack transform, float partialTicks, int mouseY, int mouseX) {
        super.func_230450_a_(transform, partialTicks, mouseY, mouseX);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableLighting();
        if (this.searchField != null) {
            this.searchField.func_230430_a_(transform, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        if (this.searchField != null && this.searchField.func_231046_a_(key, scanCode, modifiers)) {
            this.scrollBar.setValue(0);
            this.selection.filterEntries(this.searchField.func_146179_b());
            return true;
        }
        return super.func_231046_a_(key, scanCode, modifiers);
    }

    @Override
    @Nullable
    protected Slot getSlotAtPosition(double mouseX, double mouseY) {
        Slot slot = super.getSlotAtPosition(mouseX, mouseY);
        if (slot instanceof SlotGeneticFilter && this.selection.getLogic() != null) {
            return null;
        }
        return slot;
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        Widget widget;
        if (super.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.searchField != null) {
            this.searchField.func_231044_a_(mouseX, mouseY, mouseButton);
        }
        if ((widget = this.widgetManager.getAtPosition(mouseX - (double)this.field_147003_i, mouseY - (double)this.field_147009_r)) == null) {
            this.deselectFilter();
        }
        return true;
    }

    @Override
    protected void addLedgers() {
        this.addHintLedger("filter");
    }

    public IFilterLogic getLogic() {
        return this.tile.getLogic();
    }
}

